<?php
 /**
 * Contact Info Widget
 */
class Rola_contact_info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Contact Info', 'rola-toolkit'));
        parent::__construct( false, esc_html__('Rola Footer Contact Info', 'rola-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $rola_theme;

        $title  = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($before_widget);
        if($title) echo wp_kses_post($before_title.$title.$after_title);
        ?>

            <ul class="footer-information">
                <?php if( $instance['location'] != '' ): ?>
                <li>
                    <span><?php echo esc_html($instance['loc_title']); ?></span>
                    <?php echo esc_html($instance['location']); ?>
                </li>
                <?php endif; ?>

                <?php if( $instance['phone_num'] != '' ): ?>
                <li>
                    <span><?php echo esc_html($instance['phone_title']); ?></span>
                    <a href="<?php echo esc_url($instance['phone_link']); ?>"><?php echo esc_html($instance['phone_num']); ?></a>
                </li>
                <?php endif; ?>

                <?php if( $instance['email_add'] != '' ): ?>
                <li>
                    <span><?php echo esc_html($instance['email_title']); ?></span>
                    <a href="<?php echo esc_url($instance['email_link']); ?>"><?php echo esc_html($instance['email_add']); ?></a>
                </li>
                <?php endif; ?>
            </ul>

            <div class="share-link">
                <?php if( $instance['facebook_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['facebook_url']); ?>" target="_blank"><i class='bx bxl-facebook'></i></a>
                <?php endif; ?>

                <?php if( $instance['twitter_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['twitter_url']); ?>" target="_blank"><i class='bx bxl-twitter'></i></a>
                <?php endif; ?>

                <?php if( $instance['linkedin_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['linkedin_url']); ?>" target="_blank"><i class='bx bxl-linkedin'></i></a>
                <?php endif; ?>

                <?php if( $instance['instagram_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['instagram_url']); ?>" target="_blank"><i class='bx bxl-instagram'></i></a>
                <?php endif; ?>

                <?php if( $instance['youtube_url'] != '' ): ?>
                <a href="<?php echo esc_url($instance['youtube_url']); ?>" target="_blank"><i class='bx bxl-youtube'></i></a>
                <?php endif; ?>
            </div>

        <?php
        echo wp_kses_post($after_widget);
    }

    function update($new_instance, $old_instance){
        $instance                    = $old_instance;
        $instance['title']           = strip_tags($new_instance['title']);

        $instance['loc_title']    = $new_instance['loc_title'];
        $instance['location']     = $new_instance['location'];

        $instance['phone_title']    = $new_instance['phone_title'];
        $instance['phone_num']      = $new_instance['phone_num'];
        $instance['phone_link']     = $new_instance['phone_link'];

        $instance['email_title']    = $new_instance['email_title'];
        $instance['email_add']      = $new_instance['email_add'];
        $instance['email_link']     = $new_instance['email_link'];

        $instance['facebook_url']          = $new_instance['facebook_url'];
        $instance['twitter_url']           = $new_instance['twitter_url'];
        $instance['linkedin_url']          = $new_instance['linkedin_url'];
        $instance['instagram_url']         = $new_instance['instagram_url'];
        $instance['youtube_url']           = $new_instance['youtube_url'];

        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'           => esc_html__('Help', 'rola-toolkit'),

            'loc_title'       =>  esc_html__('Our Location', 'rola-toolkit'),
            'location'        =>  esc_html__('35 West Dental Street California 1004', 'rola-toolkit'),

            'phone_title'     => esc_html__('Call Today', 'rola-toolkit'),
            'phone_num'       => esc_html__('+088 123 654 987', 'rola-toolkit'),
            'phone_link'      => '#',

            'email_title'      =>  esc_html__('Email: ', 'rola-toolkit'),
            'email_add'        => 'contactinfo@rola.com',
            'email_link'       =>  esc_html__('mailto:contactinfo@rola.com', 'rola-toolkit'),

            'facebook_url'            => '#',
            'twitter_url'             => '#',
            'linkedin_url'            => '#',
            'instagram_url'           => '#',
            'youtube_url'             => '#',

           
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <?php esc_html_e('Title:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo wp_kses_post($instance['title']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('loc_title')); ?>">
                <?php esc_html_e('Location Title:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('loc_title')); ?>" name="<?php echo esc_attr($this->get_field_name('loc_title')); ?>" type="text" value="<?php echo wp_kses_post($instance['loc_title']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('location')); ?>">
                <?php esc_html_e('Location:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('location')); ?>" name="<?php echo esc_attr($this->get_field_name('location')); ?>" type="text" value="<?php echo wp_kses_post($instance['location']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_title')); ?>">
                <?php esc_html_e('Phone Title:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('phone_title')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_title')); ?>" type="text" value="<?php echo wp_kses_post($instance['phone_title']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_num')); ?>">
                <?php esc_html_e('Phone Number:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('phone_num')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_num')); ?>" type="text" value="<?php echo wp_kses_post($instance['phone_num']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_link')); ?>">
                <?php esc_html_e('Phone Link:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('phone_link')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_link')); ?>" type="text" value="<?php echo wp_kses_post($instance['phone_link']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email_title')); ?>">
                <?php esc_html_e('Email Title:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('email_title')); ?>" name="<?php echo esc_attr($this->get_field_name('email_title')); ?>" type="text" value="<?php echo wp_kses_post($instance['email_title']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email_add')); ?>">
                <?php esc_html_e('Email Address:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('email_add')); ?>" name="<?php echo esc_attr($this->get_field_name('email_add')); ?>" type="text" value="<?php echo wp_kses_post($instance['email_add']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email_link')); ?>">
                <?php esc_html_e('Email Link:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('email_link')); ?>" name="<?php echo esc_attr($this->get_field_name('email_link')); ?>" type="text" value="<?php echo wp_kses_post($instance['email_link']); ?>" />
            </label>
        </p>


        <p>
            <label for="<?php echo esc_attr($this->get_field_id('facebook_url')); ?>">
                <?php esc_html_e('Facebook URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('facebook_url')); ?>" name="<?php echo esc_attr($this->get_field_name('facebook_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['facebook_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('twitter_url')); ?>">
                <?php esc_html_e('Twitter URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('twitter_url')); ?>" name="<?php echo esc_attr($this->get_field_name('twitter_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['twitter_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('linkedin_url')); ?>">
                <?php esc_html_e('Linkedin URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('linkedin_url')); ?>" name="<?php echo esc_attr($this->get_field_name('linkedin_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['linkedin_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('instagram_url')); ?>">
                <?php esc_html_e('Instagram URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('instagram_url')); ?>" name="<?php echo esc_attr($this->get_field_name('instagram_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['instagram_url']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('youtube_url')); ?>">
                <?php esc_html_e('Youtube URL:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('youtube_url')); ?>" name="<?php echo esc_attr($this->get_field_name('youtube_url')); ?>" type="text" value="<?php echo wp_kses_post($instance['youtube_url']); ?>" />
            </label>
        </p>
      
        
        <?php
    }

}

function rola_register_contact_info() {
    register_widget('Rola_contact_info');
}

add_action('widgets_init', 'rola_register_contact_info');