<?php
/**
 * Appointment Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Appointment_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_App_Area';
    }

	public function get_title() {
        return esc_html__( 'Appointment', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => __( 'Appointment', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'rola-toolkit' ),
                        '2'   => __( 'Style 2', 'rola-toolkit' ),
                        '3'   => __( 'Style 3', 'rola-toolkit' ),
                        '4'   => __( 'Style 4', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'app_image',
                [
                    'label'  => __( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'choose_icon',
                [
                    'label'      => __( 'Icon', 'teciva-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'app_form_title',
                [
                    'label'   => __( 'Form Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'app_form_shortcode',
                [
                    'label'   => __( 'Form Shortcode', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'form_icon_color',
                [
                    'label'     => __( 'Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-overview-box .make-appointment-content h4 i, .appointment-inner-box .appointment-form h4 i, .appointment-form h4 i, .dental-tourism-appointment-form h4 i, .skin-care-appointment-form h4 i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'form_title_color',
                [
                    'label'     => __( 'Form Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .appointment-form h4, .dental-tourism-appointment-form h4, .skin-care-appointment-form h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'form_title_typography',
                    'label'    => __( 'Form Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .appointment-form h4, .dental-tourism-appointment-form h4, .skin-care-appointment-form h4',
                ]
            );

            $this->add_control(
                'form_bg_color',
                [
                    'label'     => __( 'Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-appointment-area .row' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '4',
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $form     = $settings['app_form_shortcode'];
        ?>

        <?php if ( $settings['choose_style'] == '1' ) : ?>
            <div class="appointment-area bg-image ptb-100" style="background-image: url(<?php echo esc_url( $settings['app_image']['url']); ?> )">
                <div class="container">
                    <?php if(  $form != '' ) : ?>
                        <div class="appointment-form">
                            <h4><i class="<?php echo esc_attr( $settings['choose_icon'] ); ?>"></i> <?php echo wp_kses_post( $settings['app_form_title'] ); ?></h4>

                            <?php echo do_shortcode( $form ); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '2' ) : ?>
            <div class="appointment-area-wrap" >
                <div class="container">
                    <div class="appointment-inner-box" style="background-image: url(<?php echo esc_url( $settings['app_image']['url']); ?> )">
                        <?php if(  $form != '' ) : ?>
                            <div class="appointment-form">
                                <h4><i class="<?php echo esc_attr( $settings['choose_icon'] ); ?>"></i> <?php echo wp_kses_post( $settings['app_form_title'] ); ?></h4>
                                <?php echo do_shortcode( $form ); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '3' ) : ?>
            <div class="dental-tourism-appointment-area ptb-100" style="background-image: url(<?php echo esc_url( $settings['app_image']['url']); ?> )">
                <div class="container">
                    <div class="dental-tourism-appointment-form">
                        <h4><i class="<?php echo esc_attr( $settings['choose_icon'] ); ?>"></i> <?php echo wp_kses_post( $settings['app_form_title'] ); ?></h4>

                        <?php echo do_shortcode( $form ); ?>
                    </div>
                </div>
            </div>
        <?php else : ?>
            <div class="skin-care-appointment-area">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-6 col-md-12">
                            <div class="skin-care-appointment-image" style="background-image: url(<?php echo esc_url( $settings['app_image']['url']); ?> )"></div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="skin-care-appointment-form">
                                <h4><i class="<?php echo esc_attr( $settings['choose_icon'] ); ?>"></i> <?php echo wp_kses_post( $settings['app_form_title'] ); ?></h4>

                                <?php echo do_shortcode( $form ); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Appointment_Area );