<?php
/**
 * Rola Doctors Details Widget
 */

namespace Elementor;
class Rola_Doctors_Details extends Widget_Base {

	public function get_name() {
        return 'Rola_Doctors_Details';
    }

	public function get_title() {
        return __( 'Doctors Details', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_Features_Details',
			[
				'label' => __( 'Rola Section', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'sec_title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Introduction Title', 'rola-toolkit' ),
                    'default' => 'Introduction',
                ]
            );
            $this->add_control(
                'sec_content',
                [
                    'type'    => Controls_Manager::TEXTAREA,
                    'label'   => __( 'Section Content', 'rola-toolkit' ),
                ]
            );
            $skill_items = new Repeater();
            $skill_items->add_control(
                'pro_percentage',
                [
                    'type'    => Controls_Manager::NUMBER,
                    'label'   => __( 'Progress Percentage', 'rola-toolkit' ),
                    'default' => 75,
                ]
            );
            $skill_items->add_control(
                'pro_title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Progress Title', 'rola-toolkit' ),
                    'default' => 'Dental Prevention',
                ]
            );
            $this->add_control(
                'pro_bar_items',
                [
                    'label'   => __( 'Add Progress Bar', 'rola-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $skill_items->get_controls(),
                ]
            );

            $this->add_control(
                'sec_content2',
                [
                    'type'    => Controls_Manager::TEXTAREA,
                    'label'   => __( 'Add Content', 'rola-toolkit' ),
                ]
            );

            $this->add_control(
                'skill_div1',
                [
                    'type'    => Controls_Manager::DIVIDER,
                ]
            );

            $this->add_control(
                'skill_title',
                [
                    'type'    => Controls_Manager::TEXTAREA,
                    'label'   => __( 'Skill Title', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'skill_list_content',
                [
                    'type'    => Controls_Manager::TEXTAREA,
                    'label'   => __( 'Add Skill Lists', 'rola-toolkit' ),
                ]
            );


            $this->add_control(
                'img_div1',
                [
                    'type'    => Controls_Manager::DIVIDER,
                ]
            );
            $this->add_control(
                'img_div2',
                [
                    'type'    => Controls_Manager::DIVIDER,
                ]
            );
            // Images
            $this->add_control(
                'images_title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Before After Images Title', 'rola-toolkit' ),
                ]
            );
            $images = new Repeater();
            $images->add_control(
                'be_image',
                [
                    'type'	  => Controls_Manager::MEDIA,
                    'label'   => __( 'Add Before Image', 'rola-toolkit' ),
                ]
            );
            $images->add_control(
                'after_image',
                [
                    'type'	  => Controls_Manager::MEDIA,
                    'label'   => __( 'Add After Image', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'add_ba_images',
                [
                    'label'   => __( 'Add Images', 'rola-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $images->get_controls(),
                ]
            );
            // Form
            $this->add_control(
                'form_div',
                [
                    'type'    => Controls_Manager::DIVIDER,
                ]
            );
            $this->add_control(
                'form_title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Form Title', 'rola-toolkit' ),
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $link = get_the_permalink();

        if ( class_exists( 'ACF') ) :
            $designation    = get_field('doctor_designation');
            $doctor_info    = get_field('doctor_info');
            $form           = get_field( 'form_shortcode' );
        else:
            $designation    = '';
            $doctor_info    = '';
            $form           = '';
        endif;
        ?>

        <section class="dentist-details-area ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-12">
                        <div class="dentist-details-image">
                            <div class="desc-image">
                                <?php if(!empty(get_the_post_thumbnail_url())) : ?>
                                    <img src="<?php the_post_thumbnail_url( 'full' ) ?>" alt="<?php the_title_attribute(); ?>">
                                <?php endif; ?>

                                <?php if( have_rows('choose_social_icons') ) : ?>
                                    <div class="share-link">
                                        <?php while( have_rows('choose_social_icons') ): the_row(); ?>
                                            <a href="<?php echo esc_url( get_sub_field('link') ); ?>" target="_blank"><i class='<?php echo esc_attr( get_sub_field('choose_doctor_icon') ); ?>'></i>
                                            </a>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="desc-content">
                                <h3> <?php the_title(); ?> </h3>
                                <span><?php echo esc_html( $designation ); ?></span>
                            </div>

                            <div class="desc-info-item">
                                <?php echo wp_kses_post( $doctor_info ); ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-8 col-md-12">
                        <div class="dentist-details-desc">
                            <div class="introduction-content">
                                <?php if( $settings['sec_title']  != '' ) : ?>
                                    <h3><?php echo esc_html( $settings['sec_title'] ); ?></h3>
                                <?php endif; ?>

                                <!-- Paragraph -->
                                <?php if( $settings['sec_content']  != '' ) : ?>
                                    <?php echo wp_kses_post($settings['sec_content']); ?>
                                <?php endif; ?>

                                <!-- Loop Skill Bar -->
                                <?php foreach ( $settings['pro_bar_items'] as $item ) : ?>
                                    <div class="skill-bar" data-percentage="<?php echo esc_attr($item['pro_percentage']); ?>%">
                                        <p class="progress-title-holder">
                                            <span class="progress-title"><?php echo esc_html($item['pro_title']); ?></span>
                                            <span class="progress-number-wrapper">
                                                <span class="progress-number-mark">
                                                    <span class="percent"></span>
                                                    <span class="down-arrow"></span>
                                                </span>
                                            </span>
                                        </p>
                                        <div class="progress-content-outter">
                                            <div class="progress-content"></div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>

                                <!-- Paragraph, lists -->
                                <?php if( $settings['sec_content2']  != '' ) : ?>
                                    <?php echo wp_kses_post($settings['sec_content2']); ?>
                                <?php endif; ?>
                            </div>

                            <!-- skill content, lists -->
                            <div class="skills-content">
                                <?php if( $settings['skill_title']  != '' ) : ?>
                                    <h3><?php echo esc_html( $settings['skill_title'] ); ?></h3>
                                <?php endif; ?>

                                <!-- Skill Lists -->
                                <?php if( $settings['skill_list_content']  != '' ) : ?>
                                    <?php echo wp_kses_post($settings['skill_list_content']); ?>
                                <?php endif; ?>
                            </div>

                            <div class="before-after-twentytwenty-image">

                                <?php if( $settings['images_title']  != '' ) : ?>
                                    <h3> <?php echo wp_kses_post($settings['images_title']); ?></h3>
                                <?php endif; ?>

                                <div class="row">
                                    <?php foreach ( $settings['add_ba_images'] as $item ) : ?>
                                        <div class="col-lg-4 col-md-12">
                                            <div class="twentytwenty-container">
                                                <?php if( $item['be_image']['url'] != '') : ?>
                                                    <img src="<?php echo esc_url( $item['be_image']['url']); ?>" alt="<?php echo esc_attr__('before image', 'rola-toolkit');?>">
                                                <?php endif; ?>
                                                <?php if( $item['after_image']['url'] != '') : ?>
                                                    <img src="<?php echo esc_url( $item['after_image']['url']); ?>" alt="<?php echo esc_attr__('after image', 'rola-toolkit');?>">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <?php if(  $form  != '') : ?>
                                <div class="book-an-appointment">
                                    <?php if( $settings['form_title']  != '' ) : ?>
                                        <h3> <?php echo wp_kses_post($settings['form_title']); ?></h3>
                                    <?php endif; ?>

                                    <?php echo do_shortcode(get_field('form_shortcode')); ?>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>

                </div>
            </div>
        </section>

        <script>
            jQuery(document).ready(function() {

                <?php if ( rola_rtl() == true ) {
                    echo("jQuery('.skill-bar').each(function() {
                        jQuery(this).find('.progress-content').animate({
                        width:jQuery(this).attr('data-percentage')
                        },2000);
                        
                        jQuery(this).find('.progress-number-mark').animate(
                        {right:jQuery(this).attr('data-percentage')},
                        {
                            duration: 2000,
                            step: function(now, fx) {
                            var data = Math.round(now);
                            jQuery(this).find('.percent').html(data + '%');
                            }
                        });  
                    });");
                } else {
                    echo("jQuery('.skill-bar').each(function() {
                        jQuery(this).find('.progress-content').animate({
                        width:jQuery(this).attr('data-percentage')
                        },2000);
                        
                        jQuery(this).find('.progress-number-mark').animate(
                        {left:jQuery(this).attr('data-percentage')},
                        {
                            duration: 2000,
                            step: function(now, fx) {
                            var data = Math.round(now);
                            jQuery(this).find('.percent').html(data + '%');
                            }
                        });  
                    });");
                } ?>
            });
        </script>

        <?php
	}


}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Doctors_Details );