<?php
/**
 *  Feedback Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_ECFeedback_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_ECFeedback';
    }

	public function get_title() {
        return esc_html__( 'Eye Care Feedback', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_feedback_section',
			[
				'label' => __( 'Feedback Controls' , 'rola' )
			]
        );
            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'icon',
                [
                    'label' => __( 'Quote Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'rev_icon',
                [
                    'label'      => __( 'Review Star Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::TEXT,
                    'default'    => ' bx bxs-star',
                ]
            );

            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'feedback',
                [
                    'label'   => esc_html__('Feedback Content', 'rola-toolkit'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas accumsan lacus vel facilisis.', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'client_img',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $repeater_items->add_control(
                'name',
                [
                    'label'       => esc_html__('Name', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__('Olivar Lucy', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'rating',
                [
                    'label'       => esc_html__('Rating', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'designation',
                [
                    'label'       => esc_html__('Designation', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__('Designer', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'rola_feedback_items',
                [
                    'label'  => __( 'Add Item', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );
		$this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'card_bgcolor',
                [
                    'label'     => esc_html__( 'Card Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-testimonials-area .row' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
				'top_title_color',
				[
					'label'     => esc_html__( 'Top Title Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-testimonials-content-box .content span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tt_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-testimonials-content-box .content span',
                ]
            );
            $this->add_control(
				'sec_title_color',
				[
					'label'     => esc_html__( 'Section Title Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-testimonials-content-box .content h3, .eye-care-testimonials-content-box .content h1, .eye-care-testimonials-content-box .content h2, .eye-care-testimonials-content-box .content h4, .eye-care-testimonials-content-box .content h5, .eye-care-testimonials-content-box .content h6' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'sec_typography',
                    'label'    => __( 'Section Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-testimonials-content-box .content h3, .eye-care-testimonials-content-box .content h1, .eye-care-testimonials-content-box .content h2, .eye-care-testimonials-content-box .content h4, .eye-care-testimonials-content-box .content h5, .eye-care-testimonials-content-box .content h6',
                ]
            );
            $this->add_control(
				'icon_color',
				[
					'label'     => esc_html__( 'Rating Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-review-card .rating li i' => 'color: {{VALUE}}',
					],
				]
			);
           
            $this->add_control(
				'feed_color',
				[
					'label'     => esc_html__( 'Feedback Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-review-card p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feed_typography',
                    'label'    => __( 'Feedback Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-review-card p',
                ]
            );
            $this->add_control(
				'name_color',
				[
					'label'     => esc_html__( 'Name Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-review-card .review-info h3' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'name_typography',
                    'label'    => __( 'Name Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-review-card .review-info h3',
                ]
            );
            $this->add_control(
				'des_color',
				[
					'label'     => esc_html__( 'Designation Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-review-card .review-info span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'des_typography',
                    'label'    => __( 'Designation Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-review-card .review-info span',
                ]
            );

            $this->add_control(
				'quo_color',
				[
					'label'     => esc_html__( 'Quote Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .eye-care-review-card .icon-quote i' => 'color: {{VALUE}}',
					],
				]
			);
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $slider   = $settings['rola_feedback_items'];
        $rev_icon = $settings['rev_icon'];
		?>
        <div class="eye-care-testimonials-area">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-7 col-md-12">
                        <div class="eye-care-testimonials-image" style="background-image: url(<?php echo esc_url( $settings['image']['url']); ?> )"></div>
                    </div>
                    <div class="col-lg-5 col-md-12">
                        <div class="eye-care-testimonials-content-box">
                            <?php if( $settings['top_title'] != '' ||  $settings['title'] != '' ) : ?>
                                <div class="content">
                                    <?php if( $settings['top_title'] != '' ) : ?>
                                        <span>
                                            <i class="<?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                            <?php echo esc_html( $settings['top_title'] ); ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if( $settings['title'] != '' ) : ?>
                                        <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <div class="eye-care-review-slides owl-carousel owl-theme">
                                <?php foreach( $slider as $key => $value ) : ?>
                                <div class="eye-care-review-card">
                                    <div class="review-info">
                                        <?php if( $value['client_img']['url'] != '') : ?>
                                            <img src="<?php echo esc_url( $value['client_img']['url']); ?>" class="rounded-circle" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                                        <?php endif; ?>
                                        <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                        <span><?php echo esc_html( $value['designation'] ); ?></span>
                                    </div>
                                    <p><?php echo esc_html( $value['feedback'] ); ?></p>
                                    <ul class="rating">
                                        <?php for( $count = 1; $count <= $value['rating']; $count++ ){ ?>
                                            <li><i class="<?php echo esc_attr( $rev_icon ); ?>"></i> </li>
                                        <?php } ?>
                                    </ul>
                                    <?php if( $settings['icon'] != '' ) : ?>
                                        <div class="icon-quote">
                                            <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_ECFeedback_Area );