<?php
/**
 * Services Widget
 */

namespace Elementor;
class Rola_Feature_Services extends Widget_Base {

	public function get_name() {
        return 'Rola_Feature_Service';
    }

	public function get_title() {
        return __( 'Feature Services', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Features Controls', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style one', 'rola-toolkit' ),
                        '2'   => __( 'Style two', 'rola-toolkit' ),
                        '3'   => __( 'Style three', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );

            $this->add_control(
                'header_size',
                [
                    'label' => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default' => 'h3',
                ]
            );
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'rola-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );

            $this->add_control(
                'btn_text',
                [
                    'label'   => __( 'Button Text', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => 'Get Started',
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Style 1 & 2
        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .single-features-card .title h3 a, .single-features-card .title h1 a, .single-features-card .title h2 a, .single-features-card .title h4 a, .single-features-card .title h5 a, .single-features-card .title h6 a, .single-features-box h3 a, .single-features-box h1 a, .single-features-box h2 a, .single-features-box h4 a, .single-features-box h5 a, .single-features-box h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-features-card .title h3 a, .single-features-card .title h1 a, .single-features-card .title h2 a, .single-features-card .title h4 a, .single-features-card .title h5 a, .single-features-card .title h6 a, .single-features-box h3 a, .single-features-box h1 a, .single-features-box h2 a, .single-features-box h4 a, .single-features-box h5 a, .single-features-box h6 a',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label'     => __( 'Excerpt Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-features-card p, .single-features-card ul li, .single-features-card ol li' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-features-card p, .single-features-card ul li, .single-features-card ol li',
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-features-card .title i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-features-card .features-btn' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-features-card .features-btn',
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
            $this->add_control(
                'card_color',
                [
                    'label'     => __( 'Card Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-features-card' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => ['1','3'],
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        } 

        $services_array = new \WP_Query( $args ); ?>

        <?php if ( $settings['choose_style'] == '1' || $settings['choose_style'] == '3' ) : ?>

            <?php if ( $settings['choose_style'] == '1' ) : ?>
            <div class="features-area pb-75">
            <?php else : ?>
            <div class="features-area bg-ffffff pt-100 pb-75">
            <?php endif; ?> 
                <div class="container">
                    <div class="row">
                        <?php $loop = 1; 
                        while( $services_array->have_posts() ): 
                            $services_array->the_post();

                            if ( class_exists('ACF') ) {
                                if ( get_field('choose_link_type') == 1 ) {
                                    $post_link = get_the_permalink();
                                } else {
                                    $post_link = get_field('external_link');
                                }

                                $icon = get_field('service_icon');
                            } else {
                                $post_link = get_field('external_link');
                                $icon      = '';
                            }

                            if( $loop == 2 ){
                                $color_cls = 'bg-E86548';
                            } elseif($loop == 3){
                                $color_cls = 'bg-456483';
                            } else{
                                $color_cls = '';
                            }

                            if($loop == 3 && $settings['count'] == 3){
                                $column = 'col-lg-4 col-md-6 offset-lg-0 offset-md-3';
                            }

                        ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="single-features-card <?php echo esc_attr( $color_cls ); ?>">
                                <div class="title">
                                    <?php if( $icon != '') : ?>
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    <?php endif; ?>
                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>
                                </div>
                                <p><?php echo get_the_excerpt(); ?></p>

                                <a href="<?php echo esc_url( $post_link ); ?>" class="features-btn"><?php echo esc_html( $settings['btn_text'] ); ?> </a>
                            </div>
                        </div>
                        <?php $loop++; endwhile;
                        wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        <?php else : ?>
            <div class="container">
                <div class="row">
                    <?php $loop = 1; 
                    while( $services_array->have_posts() ): 
                        $services_array->the_post();

                        if ( class_exists('ACF') ) {
                            if ( get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }

                            $icon = get_field('service_icon');
                        } else {
                            $post_link = get_field('external_link');
                            $icon      = '';
                        }

                        if($loop == 3 && $settings['count'] == 3){
                            $column = 'col-lg-4 col-md-6 offset-lg-0 offset-md-3';
                        }

                    ?>
                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="single-features-box">
                            <div class="content">
                                <?php if( $icon != '') : ?>
                                    <div class="icon">
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    </div>
                                <?php endif; ?>
                                <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </<?php echo esc_attr( $settings['header_size'] ); ?>>
                            </div>
                        </div>
                    </div>
                    <?php $loop++; endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php endif; ?>   

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Feature_Services );