<?php
namespace Elementor;
class RolaPricingTwo extends Widget_Base{
    public function get_name(){
        return "Rolapricing-two";
    }
    public function get_title(){
        return "Pricing Area Two";
    }
    public function get_icon(){
        return "eicon-price-table";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        // Tab controls
        $this-> start_controls_section(
            'rola_pricing',
            [
                'label' => esc_html__('Pricing Tab', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );
        $this-> end_controls_section();
        // End Tab controls

        // Monthly Plan controls
        $this-> start_controls_section(
            'rola_monthly_plan',
            [
                'label' => esc_html__('Pricing Plan', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,           
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'monthly_type', [
                'label' => esc_html__( 'Pricing Type', 'rola-toolkit' ),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'monthly_price', [
                'label' => esc_html__( 'Price Amount', 'rola-toolkit' ),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'mon_price_list',
            [
                'label' => __( 'Features', 'rola-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Cancer Services,Cardiovascular Services,Weight Management,Dental Services,Womens Health,Emergency Medicine, Family Medicine, Gynecologic Oncology *,Neurosurgery *, Radiation Oncology *', 'rola-toolkit'),
                'description'   => 'Use a comma to add a new item. If you want to add disable icon on the list then add * on the list.'
            ]
        );
        $repeater->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button Title', 'rola-toolkit'),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'link_type',
            [
                'label' => esc_html__( 'Link Type', 'rola-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'  => esc_html__( 'Link To Page', 'rola-toolkit' ),
                    '2' => esc_html__( 'External Link', 'rola-toolkit' ),
                ],
            ]
        );
        $repeater->add_control(
            'link_to_page',
            [
                'label' => esc_html__( 'Link Page', 'rola-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => rola_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );
        $repeater->add_control(
            'external_link',
            [
                'label'=>esc_html__('External Link', 'rola-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );
        $this->add_control(
            'all_monthly_plan',
            [
                'label' => esc_html__( 'Add Monthly Plan', 'rola-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        $this-> start_controls_section(
            'pricing_card_style',
            [
                'label' => esc_html__('Pricing Card', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'card_bg_color',
                [
                    'label' => esc_html__( 'Card Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'price_type',
                [
                    'label' => esc_html__( 'Pricing Type', 'rola-toolkit' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );
        
            $this->add_control(
                'type_color',
                [
                    'label' => esc_html__( 'Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table .pricing-header h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'price_typo',
                    'label'    => __( 'Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-pricing-table .pricing-header h3',
                ]
            );
            
            $this->add_control(
                'price_list',
                [
                    'label' => esc_html__( 'Pricing Feature List', 'rola-toolkit' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );
            $this->add_control(
                'price_list_color',
                [
                    'label' => esc_html__( 'Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table .pricing-features li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'price_listtypo',
                    'label'    => __( 'Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .single-pricing-table .pricing-features li',
                ]
            );
            $this->add_control(
                'price_dlist_color',
                [
                    'label' => esc_html__( 'Disable Feature Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table .pricing-features li.color-gray' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display(); 
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6';
        } else {
            $column = 'col-lg-4 col-sm-6';
        }
        
        ?>
        <!-- Start Pricing Area -->
        <div class="container">
            <div class="row"> 
                <?php 
                    $loop = 1;
                    foreach ( $settings['all_monthly_plan'] as $item ) :

                        if($item['monthly_type']!='' || $item['monthly_price']!='') { 
                            // Get Plan Button link
                            $link_source = '';
                            if($item['link_type'] == 1){
                                $link_source = get_page_link($item['link_to_page']); 
                            } else {
                                $link_source = $item['external_link'];
                            } ?>

                            <div class="<?php echo esc_attr( $column ); ?>">
                                <div class="single-pricing-table">
                                    <div class="pricing-header">
                                        <h3><?php echo esc_html($item['monthly_type']); ?></h3>
                                    </div>

                                    <div class="price"><?php echo esc_html($item['monthly_price']); ?></div>

                                    <ul class="pricing-features">
                                        <?php $lists = explode(',', $item['mon_price_list'] );
                                        foreach (  $lists as $list ) : ?>
                                            <?php if ( strpos( $list, "*" ) !== false ) : ?>
                                                <li class="color-gray"><del> <i class='bx bx-x'></i><?php echo str_replace('*', '', $list); ?></del></li>
                                            <?php else: ?>
                                                <li><i class='bx bx-check'></i><?php echo esc_html( $list ); ?></li>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </ul>

                                    <?php if( $item['btn_text'] !='' ) : ?>
                                        <div class="pricing-btn">
                                            <a href="<?php echo esc_url($link_source); ?>" class="default-btn"><?php echo esc_html($item['btn_text']); ?></a>
                                        </div>
                                    <?php  endif; ?>
                                </div>
                            </div>
                        <?php } 
                        $loop++; 
                    endforeach; 
                ?>
            </div>
        </div>
    <?php
    } 

}
Plugin::instance()->widgets_manager->register_widget_type( new RolaPricingTwo );