<?php global $rola_opt;
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package rola
*/

get_header(); ?>

	<div class="page-banner-area">
		<div class="container">
			<div class="page-banner-content text-center">
				<h2><?php echo esc_html_e('404 Error', 'rola') ?></h2>
				
				<ul class="pages-list">
					<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
					<li><?php echo esc_html_e('404 Error', 'rola') ?></li>
				</ul>
			</div>
		</div>
	</div>

	<div class="error-area ptb-100">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="error-content">
						<?php if ( isset( $rola_opt['img-404']['url'] ) && $rola_opt['img-404']['url'] !='' ) : ?>
							<img src="<?php echo esc_url( $rola_opt['img-404']['url'] ); ?> " alt="<?php esc_attr_e( '404 Image', 'rola' ); ?>">
						<?php else: ?>
							<img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/error.png' ); ?>" alt="<?php esc_attr_e( '404 Image', 'rola' ); ?>">
						<?php endif; ?>
	
						<?php if( isset( $rola_opt['content_not_found'] ) ): ?>
							<h3><?php echo esc_html( $rola_opt['content_not_found'] ); ?></h3>
						<?php else: ?>
							<h3><?php esc_html_e('Oops! Page not found', 'rola'); ?></h3>
						<?php endif; ?>

						<?php if( isset( $rola_opt['long_content_not_found'] ) ): ?>
							<p><?php echo esc_html( $rola_opt['long_content_not_found'] ); ?></p>
						<?php else: ?>
							<p><?php esc_html_e('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'rola'); ?></p>
						<?php endif; ?>

						<?php if( isset( $rola_opt['button_not_found'] ) ): ?>
							<?php if( $rola_opt['button_not_found'] != '' ): ?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn"><?php echo esc_html( $rola_opt['button_not_found'] ); ?></a>
							<?php endif; ?>
						<?php else: ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn"><?php esc_html_e( 'Back to HomeE', 'rola' ); ?></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php get_footer();