jQuery(function ($) {
    'use strict';

	jQuery(document).on('ready', function () {
	
        // Header Sticky
		$(window).on('scroll',function() {
            if ($(this).scrollTop() > 120){  
                $('.navbar-area').addClass("is-sticky");
            }
            else{
                $('.navbar-area').removeClass("is-sticky");
            }
		});

		// Mean Menu
		jQuery('.mean-menu').meanmenu({
			meanScreenWidth: "991"
        });
		
		// Others Option For Responsive JS
		$(".others-option-for-responsive .dot-menu").on("click", function(){
			$(".others-option-for-responsive .container .container").toggleClass("active");
		});

		// Search Menu JS
		$(".navbar-nav .search-box").on("click", function(){
			$(".search-overlay").toggleClass("search-overlay-active");
		});
		$(".search-overlay-close").on("click", function(){
			$(".search-overlay").removeClass("search-overlay-active");
		});
		$(".others-options .search-box").on("click", function(){
			$(".search-overlay").toggleClass("search-overlay-active");
		});
		$(".search-overlay-close").on("click", function(){
			$(".search-overlay").removeClass("search-overlay-active");
		});

		// FAQ Accordion
        $('.accordion').find('.accordion-title').on('click', function(){
			$(this).toggleClass('active');
			$(this).next().slideToggle('fast');
			$('.accordion-content').not($(this).next()).slideUp('fast');
			$('.accordion-title').not($(this)).removeClass('active');		
		});

		// Nice Select JS
        $('select').niceSelect();
        
        // Popup Video
		$('.popup-youtube').magnificPopup({
			disableOn: 320,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false
		});

		$("#datepicker").datepicker({
            minDate: 0,
            onSelect: function(dateText) {
                var today = new Date(
                    new Date().getFullYear(),
                    new Date().getMonth(),
                    new Date().getDate()
                ).getTime();
            }
        });
		
		// Go to Top
		$(window).on('scroll', function(){
			var scrolled = $(window).scrollTop();
			if (scrolled > 600) $('.go-top').addClass('active');
			if (scrolled < 600) $('.go-top').removeClass('active');
		});  
		$('.go-top').on('click', function() {
			$("html, body").animate({ scrollTop: "0" },  500);
		});
		
		// WOW Animation JS
		if($('.wow').length){
			var wow = new WOW({
				mobile: false
			});
			wow.init();
		}

		// TwentyTwenty JS
		$(function(){
			$(".twentytwenty-container[data-orientation!='vertical']").twentytwenty({default_offset_pct: 0.5});
		});

		// Disable Preloader in Elementor Edit Mode
		if($('body').hasClass("elementor-editor-active")) {
			$('.preloader').removeClass("preloader");
		};

		// Preloader
		$(window).on('load', function () {
			$('.preloader').fadeOut();
		});

		// Footer Column
		$('.colfooter-default-column:nth-child(1)').addClass('col-lg-3 col-md-6 col-sm-6');
		$('.colfooter-default-column:nth-child(2)').addClass('col-lg-2 col-md-6 col-sm-6');
		$('.colfooter-default-column:nth-child(3)').addClass('col-lg-2 col-md-3 col-sm-6');
		$('.colfooter-default-column:nth-child(4)').addClass('col-lg-2 col-md-3 col-sm-6');
		$('.colfooter-default-column:nth-child(5)').addClass('col-lg-3 col-md-6 col-sm-6');

		// Product +/-
        $(".plus-btn").on('click', function() {
            var  input = $(this).prev('input.qty');
            var val = parseInt(input.val());
            var step = input.attr('step');
            step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
            input.val( val + step ).change();
        });

        $(".minus-btn").on('click', function() {
            var input = $(this).next('input.qty');
            var val = parseInt(input.val());
            var step = input.attr('step');
            step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
            if (val > 0) {
                input.val( val - step ).change();
            }
		});


		// Products Details Image Slides
		$('.products-details-image-slides').owlCarousel({
			loop: true,
			nav: true,
			dots: false,
			autoplayHoverPause: true,
			autoplay: true,
			margin: 30,
			navText: [
				"<i class='bx bx-left-arrow-alt'></i>",
				"<i class='bx bx-right-arrow-alt'></i>",
			],
			responsive: {
				0: {
					items: 1,
				},
				576: {
					items: 2,
				},
				768: {
					items: 2,
				},
				1200: {
					items: 3,
				}
			}
		});

		// Products Details Image Slides
		$('.products-details-thumbs-image-slides').slick({
			dots: true,
			speed: 500,
			fade: false,
			slide: 'li',
			slidesToShow: 1,
			autoplay: true,
			autoplaySpeed: 4000,
			prevArrow: false,
			nextArrow: false,
			responsive: [{
				breakpoint: 800,
				settings: {
					arrows: false,
					centerMode: false,
					centerPadding: '30px',
					variableWidth: false,
					slidesToShow: 1,
					dots: true
				},
				breakpoint: 1200,
				settings: {
					arrows: false,
					centerMode: false,
					centerPadding: '30px',
					variableWidth: false,
					slidesToShow: 1,
					dots: true
				}
			}],
			customPaging: function (slider, i) {
				return '<button class="tab">' + $('.slick-thumbs li:nth-child(' + (i + 1) + ')').html() + '</button>';
			}
		});
		
	});

	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function( $scope ) {

			// Home Slides
			$('.home-slides').owlCarousel({
				loop: true,
				nav: true,
				dots: false,
				autoplayHoverPause: false,
				autoplay: true,
				autoHeight: true,
				items: 1,
				navText: [
					"<i class='bx bxs-chevron-left'></i>",
					"<i class='bx bxs-chevron-right'></i>"
				]
			});
			$(".home-slides").on("translate.owl.carousel", function(){
				$(".main-slides-content .sub-title").removeClass("animated fadeInDown").css("opacity", "0");
				$(".main-slides-content h1").removeClass("animated fadeInUp").css("opacity", "0");
				$(".main-slides-content p").removeClass("animated fadeInUp").css("opacity", "0");
				$(".main-slides-content .slides-btn .default-btn").removeClass("animated fadeInUp").css("opacity", "0");
				$(".main-slides-content .slides-btn .optional-btn").removeClass("animated fadeInUp").css("opacity", "0");
				$(".main-slides-content .slides-btn .checkup-content").removeClass("animated fadeInUp").css("opacity", "0");
			});
			$(".home-slides").on("translated.owl.carousel", function(){
				$(".main-slides-content .sub-title").addClass("animated fadeInDown").css("opacity", "1");
				$(".main-slides-content h1").addClass("animated fadeInUp").css("opacity", "1");
				$(".main-slides-content p").addClass("animated fadeInUp").css("opacity", "1");
				$(".main-slides-content .slides-btn .default-btn").addClass("animated fadeInUp").css("opacity", "1");
				$(".main-slides-content .slides-btn .optional-btn").addClass("animated fadeInUp").css("opacity", "1");
				$(".main-slides-content .slides-btn .checkup-content").addClass("animated fadeInUp").css("opacity", "1");
			});

			// Review Slides
			$('.review-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 25,
		
				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 2,
					}
				}
			});

			$('.review-slides-two').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 25,
		
				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 3,
					}
				}
			});

			// Doctor Slides
			$('.doctor-slides').owlCarousel({
				loop: false,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 25,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 4,
					}
				}
			});

			// Odometer JS
			$('.odometer').appear(function(e) {
				var odo = $(".odometer");
				odo.each(function() {
					var countNumber = $(this).attr("data-count");
					$(this).html(countNumber);
				});
			});

			// Tabs
			$('.tab ul.tabs').addClass('active').find('> li:eq(0)').addClass('current');
			$('.tab ul.tabs li a').on('click', function (g) {
				var tab = $(this).closest('.tab'), 
				index = $(this).closest('li').index();
				tab.find('ul.tabs > li').removeClass('current');
				$(this).closest('li').addClass('current');
				tab.find('.tab_content').find('div.tabs_item').not('div.tabs_item:eq(' + index + ')').slideUp();
				tab.find('.tab_content').find('div.tabs_item:eq(' + index + ')').slideDown();
				g.preventDefault();
			});

			// Progress Bar JS
			$('.circlechart').circlechart();

			// Skill Bar
			jQuery('.skill-bar').each(function() {
				jQuery(this).find('.progress-content').animate({
				width:jQuery(this).attr('data-percentage')
				},2000);
				
				jQuery(this).find('.progress-number-mark').animate(
				{left:jQuery(this).attr('data-percentage')},
				{
					duration: 2000,
					step: function(now, fx) {
					var data = Math.round(now);
					jQuery(this).find('.percent').html(data + '%');
					}
				});  
			});



			// New Three Demo JS

			// Dental Tourism Services JS
			$('.dental-tourism-services-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: false,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 30,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 4,
					}
				}
			});

			// Dental Tourism Dentist JS
			$('.dental-tourism-dentist-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 30,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 3,
					}
				}
			});

			// Dental Tourism Review JS
			$('.dental-tourism-review-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 30,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 2,
					}
				}
			});

			// Skin Care Review JS
			$('.skin-care-review-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 30,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 3,
					}
				}
			});

			// Skin Care Before and After JS
			$('.skin-care-before-after-slides').owlCarousel({
				stagePadding: 200,
				loop: true,
				margin: 10,
				nav: true,
				dots: false,
				items: 1,
				lazyLoad: true,
				navText: [
					"<i class='bx bx-left-arrow-alt'></i>",
					"<i class='bx bx-right-arrow-alt'></i>"
				],
				responsive:{
					0:{
						items: 1,
						stagePadding: 60
					},
					600:{
						items:1,
						stagePadding: 100
					},
					1000:{
						items: 1,
						stagePadding: 200
					},
					1200:{
						items: 1,
						stagePadding: 250
					},
					1400:{
						items: 1,
						stagePadding: 300
					},
					1600:{
						items: 1,
						stagePadding: 350
					},
					1800:{
						items:1,
						stagePadding: 400
					}
				}
			});

			// Skin Care Partner Slides
			$('.skin-care-partner-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: false,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 25,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 3,
					},
					1200: {
						items: 5,
					}
				}
			});

			// Skin Care Services Slides
			$('.eye-care-services-slides').owlCarousel({
				loop: true,
				nav: true,
				dots: false,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 25,
				navText: [
					"<i class='bx bx-left-arrow-alt'></i>",
					"<i class='bx bx-right-arrow-alt'></i>"
				],
				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 3,
					}
				}
			});

			// Eye Care Team JS
			$('.eye-care-team-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 30,

				responsive: {
					0: {
						items: 1,
					},
					768: {
						items: 2,
					},
					1200: {
						items: 3,
					}
				}
			});

			// Eye Care Review JS
			$('.eye-care-review-slides').owlCarousel({
				loop: true,
				nav: false,
				dots: true,
				autoplayHoverPause: true,
				autoplay: false,
				margin: 30,
				items: 1,
			});

			

		});
	});
		
}(jQuery));