<?php
/**
 * Register Theme Widget
 * @package Rola
*/

// Theme Sidebar
if ( ! function_exists( 'rola_widgets_init' ) ) {
    function rola_widgets_init() {
        global $rola_opt;

        register_sidebar( array(
            'name'          => esc_html__( 'Blog Sidebar', 'rola' ),
            'id'            => 'article-sidebar',
            'description'   => esc_html__( 'Add widgets here.', 'rola' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget-title">',
            'after_title'   => '</h3>',
        ) );

        // Shop Sidebar
        if ( class_exists( 'WooCommerce' ) ){
            register_sidebar( array( 
                'name'          => esc_html__( 'Shop Sidebar', 'rola' ),
                'id'            => 'shop',
                'description'   => esc_html__( 'Add widgets here.', 'rola' ),
                'before_widget' => '<div class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="widget-title">',
                'after_title'   => '</h3>',
            ) );
        }

        // Footer Sidebar
        $footer_column = isset( $rola_opt['footer_column']) ? $rola_opt['footer_column'] : '-4';
        register_sidebar( array(
            'name'          => esc_html__( 'Footer Widgets', 'rola' ),
            'id'            => 'footer_widgets',
            'description'   => esc_html__( 'Add widgets here.', 'rola' ),
            'before_widget' => '<div class="single-footer-widget col'.$footer_column.' %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3 class="widget_title">',
            'after_title'   => '</h3>',
        ) );

    }
}
add_action( 'widgets_init', 'rola_widgets_init' );