<?php
/**
 * The archive file
 * @package rola
 */
get_header();

// Blog Sidebar
if( isset( $rola_opt['rola_blog_sidebar'] ) ) {
    if( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar_center' ) :
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar' ) :
        $rola_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $rola_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $rola_opt['rola_blog_sidebar'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $rola_sidebar_class = 'col-lg-8 col-md-12';
        $sidebar_hide = 'rola_with_sidebar_right';
    else:
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'rola_without_sidebar';
    endif;
}

$post_page_id       = get_option( 'page_for_posts' );
if( function_exists('acf_add_options_page') ) {
	$hide_blog_banner 	= get_field( 'enable_page_banner', $post_page_id);
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb' , $post_page_id);
	$custom_title 	    = get_field( 'enable_cus_pagetitle' , $post_page_id);
    $banner_style 	    = get_field( 'choose_banner_style' , $post_page_id);
} else {
	$hide_blog_banner 	= false;
	$hide_breadcrumb 	= false;
	$custom_title 	    = false;
    $banner_style 	    = 2;
}

$post_toptitle  = isset( $rola_opt['post_toptitle']) ? $rola_opt['post_toptitle'] : '';
$post_sec_title = isset( $rola_opt['post_sec_title']) ? $rola_opt['post_sec_title'] : '';

// After Hiding Banner add spacing
if( $hide_blog_banner == true ) {
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}
$page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
$page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';
?>

    <!-- Start Page Title Area -->
    <?php if( $hide_blog_banner == false ) : ?>
        <div class="page-banner-area">
            <div class="container">
				<?php if($banner_style == 1) : ?>
					<div class="row align-items-center">
						<div class="col-lg-6 col-md-6">
							<div class="page-banner-content">
                                <?php if( $custom_title == true && get_field( 'cus_pagetitle' , $post_page_id) != '' ) { ?>
                                    <h2><?php echo esc_html( get_field( 'cus_pagetitle' , $post_page_id ) ); ?></h2>
                                <?php } else { ?>
                                    <h2> <?php esc_html_e( 'Blog', 'rola' ); ?> </h2>
                                <?php } ?>

                                <?php if( $hide_breadcrumb == false ) : ?>
                                    <ul class="pages-list">
                                        <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
                                        <?php if( $custom_title == true && get_field( 'cus_pagetitle' , $post_page_id) != '' ) { ?>
                                            <li class="active"><?php echo esc_html( get_field( 'cus_pagetitle' , $post_page_id ) ); ?></li>
                                        <?php } else { ?>
                                            <li class="active"><?php esc_html_e( 'Blog', 'rola' ); ?></li>
                                        <?php } ?>
                                    </ul>
                                <?php endif; ?>
							</div>
						</div>

						<?php if( get_the_post_thumbnail_url($post_page_id) != '') : ?>
							<div class="col-lg-6 col-md-6">
								<div class="page-banner-image text-end">
									<img src="<?php echo esc_url( get_the_post_thumbnail_url($post_page_id) ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
								</div>
							</div>
						<?php endif; ?>

					</div>
				<?php else: ?>
					<div class="page-banner-content text-center">
                        <?php if( $custom_title == true && get_field( 'cus_pagetitle' , $post_page_id) != '' ) { ?>
                            <h2><?php echo esc_html( get_field( 'cus_pagetitle' , $post_page_id ) ); ?></h2>
                        <?php } else { ?>
                            <h2> <?php esc_html_e( 'Blog', 'rola' ); ?> </h2>
                        <?php } ?>

                        <?php if( $hide_breadcrumb == false ) : ?>
                            <ul class="pages-list">
                                <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
                                <?php if( $custom_title == true && get_field( 'cus_pagetitle' , $post_page_id) != '' ) { ?>
                                    <li class="active"><?php echo esc_html( get_field( 'cus_pagetitle' , $post_page_id ) ); ?></li>
                                <?php } else { ?>
                                    <li class="active"><?php esc_html_e( 'Blog', 'rola' ); ?></li>
                                <?php } ?>
                            </ul>
                        <?php endif; ?>
					</div>
				<?php endif; ?>

            </div>
			<?php if( $page_shape1 != '') : ?>
				<div class="page-banner-shape-1">
					<img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
				</div>
			<?php endif; ?>
			<?php if( $page_shape2 != '') : ?>
				<div class="page-banner-shape-2">
					<img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
				</div>
			<?php endif; ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <!-- Start Blog Area -->
    <div class="blog-area pt-100 pb-100 <?php echo esc_attr( $page_spac ); ?>">
        <div class="container">

        <?php if( $post_toptitle != '' ||  $post_sec_title != '') : ?>
            <div class="section-title">
                <?php if( $post_toptitle != '' ) : ?>
                    <span class="sub-title">
                        <i class="flaticon-hashtag-symbol"></i>
                        <?php echo esc_html( $post_toptitle ); ?>
                    </span>
                <?php endif; ?>

                <h2><?php echo wp_kses_post( $post_sec_title ); ?></h2>
            </div>
        <?php endif; ?>

            <div class="row">
                <?php if( $sidebar_hide == 'rola_with_sidebar_left' ): ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
                <!-- Start Blog Content -->
                <div class="<?php echo esc_attr( $rola_sidebar_class ); ?>">
                    <?php
                    if ( have_posts() ) :
                        while ( have_posts() ) :
                            the_post();
                            get_template_part( 'template-parts/content', get_post_format());
                        endwhile;
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                    endif;
                    ?>
            
                    <!-- Stat Pagination -->
                    <?php rola_pagination(); ?>
                    <!-- End Pagination -->
                </div>
                <!-- End Blog Content -->
                
                <?php if( $sidebar_hide == 'rola_with_sidebar_right' ): ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
            </div>   
        </div>
    </div>
    <!-- End Blog Area -->

<?php
get_footer();