<?php
/**
 * Single Services
 */
get_header();

    global $rola_opt;

    // Services Sidebar
    if( isset( $rola_opt['rola_service_sidebar'] ) ) {
        if( $rola_opt['rola_service_sidebar'] == 'rola_without_sidebar_center' ) :
            $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        elseif( $rola_opt['rola_service_sidebar'] == 'rola_without_sidebar' ) :
            $rola_sidebar_class = 'col-lg-12 col-md-12';
        else:
            $rola_sidebar_class = 'col-lg-8 col-md-12';
        endif;
        $sidebar_hide           = $rola_opt['rola_service_sidebar'];
    } else {
        $rola_sidebar_class         = 'col-lg-8 col-md-12';
        $sidebar_hide               = 'rola_with_sidebar';
    }

    if( function_exists('acf_add_options_page') ) {
        $hide_banner 		= get_field( 'enable_page_banner' );
        $hide_breadcrumb 	= get_field( 'hide_breadcrumb' );
        $custom_title 	    = get_field( 'enable_cus_pagetitle' );
        $banner_style 	    = get_field( 'choose_banner_style' );
        $bg_img             = get_field( 'post_banner_background_image' );

    }else {
        $hide_banner 		= false;
        $hide_breadcrumb 	= false;
        $custom_title 	    = false;
        $banner_style 	    = 1;
        $bg_img             = '';
    }
    // After Hiding Banner add spacing
    if( $hide_banner == true ) {
        $page_spac = 'mt-80';
    } else {
        $page_spac = '';
    }
    
    $page_shape1         = !empty($rola_opt['page_shape1']['url']) ? $rola_opt['page_shape1']['url'] : '';
    $page_shape2         = !empty($rola_opt['page_shape2']['url']) ? $rola_opt['page_shape2']['url'] : '';

?>
    <?php if( $hide_banner == false ) : ?>
        <div class="page-banner-area">
            <div class="container">
				<?php if($banner_style == 1) : ?>
					<div class="row align-items-center">
						<div class="col-lg-6 col-md-6">
							<div class="page-banner-content">
								<?php if( $custom_title == true && get_field( 'cus_pagetitle' ) != '' ) { ?>
									<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
								<?php } else { ?>
									<h2><?php the_title(); ?></h2>
								<?php } ?>

								<?php if( $hide_breadcrumb == false ) : ?>
									<ul class="pages-list">
										<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
										<li><?php the_title(); ?></li>
									</ul>
								<?php endif; ?>
							</div>
						</div>

						<?php if( $bg_img != '') : ?>
							<div class="col-lg-6 col-md-6">
								<div class="page-banner-image text-end">
									<img src="<?php echo esc_url( $bg_img ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
								</div>
							</div>
						<?php endif; ?>

					</div>
				<?php else: ?>
					<div class="page-banner-content text-center">
						<?php if( $custom_title == true && get_field( 'cus_pagetitle' ) != '' ) { ?>
							<h2><?php echo esc_html( get_field( 'cus_pagetitle' ) ); ?></h2>
						<?php } else { ?>
							<h2><?php the_title(); ?></h2>
						<?php } ?>

						<?php if( $hide_breadcrumb == false ) : ?>
							<ul class="pages-list">
								<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'rola' ); ?></a></li>
								<li><?php the_title(); ?></li>
							</ul>
						<?php endif; ?>
					</div>
				<?php endif; ?>

            </div>
			<?php if( $page_shape1 != '') : ?>
				<div class="page-banner-shape-1">
					<img src="<?php echo esc_url( $page_shape1 ); ?> " alt="<?php esc_attr_e( 'Shape1', 'rola' ); ?>">
				</div>
			<?php endif; ?>
			<?php if( $page_shape2 != '') : ?>
				<div class="page-banner-shape-2">
					<img src="<?php echo esc_url( $page_shape2 ); ?> " alt="<?php esc_attr_e( 'Shape2', 'rola' ); ?>">
				</div>
			<?php endif; ?>
        </div>
    <?php endif; ?>

    <div class="services-details-area ptb-100">
        <div class="container">
            <?php while ( have_posts() ) : the_post(); ?>
                <div class="row">
                    <?php if( $sidebar_hide == 'rola_with_sidebar' ) : 
                        get_template_part('template-parts/cus-service','sidebar');
                    endif; ?>

                    <div class="<?php echo esc_attr( $rola_sidebar_class ); ?>">
                        <div class="services-details-desc">
                            <?php if(!empty(get_the_post_thumbnail_url())) : ?>
                                <div class="services-details-image">
                                    <img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
                                    <div class="icon">
                                        <i class="flaticon-dental-insurance"></i>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    </div>
<?php get_footer();