<?php

/**
 * Author Widget
 */
class Rola_author_info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Author Info', 'rola-toolkit'));
        parent::__construct( false, esc_html__('Rola Author Info', 'rola-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $rola_theme;

        echo wp_kses_post($before_widget);
        ?>
            <div class="widget widget_quote_info">
                <div class="quote-info-box">
                    <div class="info-item">
                        <div class="rating">
                            <?php for( $i = 1; $i <= $instance['author_rating']; $i++ ) { ?>
                                <i class="flaticon-star"></i>
                            <?php } ?>
                        </div>

                        <?php if( $instance['author_feed'] != '' ): ?>
                            <p><?php echo esc_html($instance['author_feed']); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="info">
                        <?php if ( $instance['author_image_link'] !='' ) : ?>
                            <img src="<?php echo esc_url($instance['author_image_link'] ); ?> " alt="<?php esc_attr_e( 'Author Image Link', 'rola' ); ?>" >
                        <?php endif; ?>
                        <?php if( $instance['author_name'] != '' ): ?>
                            <h3><?php echo esc_html($instance['author_name']); ?></h3>
                        <?php endif; ?>
                        <?php if( $instance['author_des'] != '' ): ?>
                            <span><?php echo esc_html($instance['author_des']); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

        <?php
        echo wp_kses_post($after_widget);
    }

    function update($new_instance, $old_instance){
        $instance                          = $old_instance;
        $instance['author_rating']         = $new_instance['author_rating'];
        $instance['author_feed']           = $new_instance['author_feed'];
        $instance['author_image_link']     = $new_instance['author_image_link'];
        $instance['author_name']           = $new_instance['author_name'];
        $instance['author_des']            = $new_instance['author_des'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'author_rating'                 => '5',
            'author_feed'                   => esc_html__('Lorem ipsum dolor sit amet consectetur adipiscing elit ut arcu a dignissim suscipit non ac eget tellus in nisl mauris nec.', 'rola-toolkit'),
            'author_image_link'             => '#',
            'author_name'                   => esc_html__('Sarah Taylor'),
            'author_des'                    => esc_html__('Obstetrics & Gynaecology', 'rola-toolkit'),
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('author_rating')); ?>">
                <?php esc_html_e('Author Rating:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('author_rating')); ?>" name="<?php echo esc_attr($this->get_field_name('author_rating')); ?>" type="text" value="<?php echo wp_kses_post($instance['author_rating']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('author_feed')); ?>">
                <?php esc_html_e('Author Feedback:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('author_feed')); ?>" name="<?php echo esc_attr($this->get_field_name('author_feed')); ?>" type="text" value="<?php echo wp_kses_post($instance['author_feed']); ?>" />
            </label>
        </p>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('author_image_link')); ?>">
                <?php esc_html_e('Author Image Link:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('author_image_link')); ?>" name="<?php echo esc_attr($this->get_field_name('author_image_link')); ?>" type="text" value="<?php echo wp_kses_post($instance['author_image_link']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('author_name')); ?>">
                <?php esc_html_e('Author Name:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('author_name')); ?>" name="<?php echo esc_attr($this->get_field_name('author_name')); ?>" type="text" value="<?php echo wp_kses_post($instance['author_name']); ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('author_des')); ?>">
                <?php esc_html_e('Author Designation:', 'rola-toolkit'); ?>
                <input class="widget" id="<?php echo esc_attr($this->get_field_id('author_des')); ?>" name="<?php echo esc_attr($this->get_field_name('author_des')); ?>" type="text" value="<?php echo wp_kses_post($instance['author_des']); ?>" />
            </label>
        </p>
        <?php
    }

}

function rola_register_author_info() {
    register_widget('Rola_author_info');
}

add_action('widgets_init', 'rola_register_author_info');