<?php
/**
 * Nervous Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Nervous_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_Nervous_Area';
    }

	public function get_title() {
        return esc_html__( 'Nervous Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_nervous_Area',
			[
				'label' => esc_html__( 'Nervous Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
        
            $this->add_control(
                'top_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'contact_title',
                [
                    'label'   => esc_html__( 'Contact Text', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'contact_num',
                [
                    'label'   => esc_html__( 'Contact Number', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'contact_link',
                [
                    'label'   => esc_html__( 'Contact Link', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );

            $this->add_control(
                'sec_image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'sec_bgcolor',
                [
                    'label'     => __( ' Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .nervous-area' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .nervous-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'toptitle_bgcolor',
                [
                    'label'     => __( 'Top Title Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .nervous-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'toptitle_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .nervous-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .nervous-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .nervous-content h3',
                ]
            );
            $this->add_control(
                'contact_color',
                [
                    'label'     => __( 'Contact Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .nervous-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'contitle_typography',
                    'label'    => __( 'Contact Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .nervous-content p',
                ]
            );
            $this->add_control(
                'contact_nhmcolor',
                [
                    'label'     => __( 'Contact Number Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .nervous-content p a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'connum_typography',
                    'label'    => __( 'Contact Number Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .nervous-content p a',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        ?>
        <div class="nervous-area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="nervous-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <i class=" <?php echo esc_attr( $settings['top_icon'] ); ?>"></i>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>

                            <?php if($settings['title'] != '') : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>

                            <p><?php echo esc_html( $settings['contact_title'] ); ?> <a href="<?php echo esc_url( $settings['contact_link'] ); ?>"><?php echo esc_html( $settings['contact_num'] ); ?></a></p>
                        </div>
                    </div>

                    <?php if( $settings['sec_image']['url'] != '') : ?>
                        <div class="col-lg-6">
                            <div class="nervous-image">
                                <img src="<?php echo esc_url( $settings['sec_image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Nervous_Area );