<?php
namespace Elementor;
class RolaPricingWidget extends Widget_Base{
    public function get_name(){
        return "pricing-widget";
    }
    public function get_title(){
        return "Pricing Area";
    }
    public function get_icon(){
        return "eicon-price-table";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        // Tab controls
        $this-> start_controls_section(
            'rola_pricing',
            [
                'label' => esc_html__('Pricing Tab', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'monthly_plan_text', [
                    'label'   => esc_html__( 'Monthly Plan Text', 'rola-toolkit' ),
                    'type'    => Controls_Manager:: TEXT,
                    'default' => esc_html__( 'Monthly', 'rola-toolkit' ),
                ]
            );

            $this->add_control(
                'yearly_plan_text', [
                    'label'   => esc_html__( 'Yearly Plan Text', 'rola-toolkit' ),
                    'type'    => Controls_Manager:: TEXT,
                    'default' => esc_html__( 'Yearly', 'rola-toolkit' ),
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '4',
                ]
            );
        $this-> end_controls_section();
        // End Tab controls

        // Monthly Plan controls
        $this-> start_controls_section(
            'rola_monthly_plan',
            [
                'label' => esc_html__('Monthly Plan', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'monthly_plan_text!' => '',
                ]            
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'monthly_type', [
                'label' => esc_html__( 'Pricing Type', 'rola-toolkit' ),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'monthly_price', [
                'label' => esc_html__( 'Price Amount', 'rola-toolkit' ),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'mon_price_list',
            [
                'label' => __( 'Features', 'rola-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Cancer Services,Cardiovascular Services,Weight Management,Dental Services,Womens Health,Emergency Medicine, Family Medicine, Gynecologic Oncology *,Neurosurgery *, Radiation Oncology *', 'rola-toolkit'),
                'description'   => 'Use a comma to add a new item. If you want to add disable icon on the list then add * on the list.'
            ]
        );
        $repeater->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button Title', 'rola-toolkit'),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'link_type',
            [
                'label' => esc_html__( 'Link Type', 'rola-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'  => esc_html__( 'Link To Page', 'rola-toolkit' ),
                    '2' => esc_html__( 'External Link', 'rola-toolkit' ),
                ],
            ]
        );
        $repeater->add_control(
            'link_to_page',
            [
                'label' => esc_html__( 'Link Page', 'rola-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => rola_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );
        $repeater->add_control(
            'external_link',
            [
                'label'=>esc_html__('External Link', 'rola-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );
        $this->add_control(
            'all_monthly_plan',
            [
                'label' => esc_html__( 'Add Monthly Plan', 'rola-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();
        // End Monthly Plan controls

        // Yearly Plan controls
        $this-> start_controls_section(
            'rola_yearly_plan',
            [
                'label'=>esc_html__('Yearly Plan', 'rola-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'yearly_plan_text!' => '',
                ]         
            ]
        );

        $repeater2 = new Repeater();
        $repeater2->add_control(
            'yearly_type', [
                'label' => esc_html__( 'Pricing Type', 'rola-toolkit' ),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater2->add_control(
            'yearly_price', [
                'label' => esc_html__( 'Price', 'rola-toolkit' ),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $repeater2->add_control(
            'year_price_list',
            [
                'label' => __( 'Features', 'rola-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Cancer Services,Cardiovascular Services,Weight Management,Dental Services,Womens Health,Emergency Medicine, Family Medicine, Gynecologic Oncology *,Neurosurgery *, Radiation Oncology *', 'rola-toolkit'),
                'description'   => 'Use a comma to add a new item. If you want to add disable icon on the list then add * on the list.'
            ]
        );
        $repeater2->add_control(
            'year_btn_text',
            [
                'label'=>esc_html__('Button Title', 'rola-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $repeater2->add_control(
            'link_type2',
            [
                'label' => esc_html__( 'Link Type', 'rola-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'  => esc_html__( 'Link To Page', 'rola-toolkit' ),
                    '2' => esc_html__( 'External Link', 'rola-toolkit' ),
                ],
            ]
        );
        $repeater2->add_control(
            'link_to_page2',
            [
                'label' => esc_html__( 'Link Page', 'rola-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => rola_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type2' => '1',
                ]
            ]
        );
        $repeater2->add_control(
            'external_link2',
            [
                'label'=>esc_html__('External Link', 'rola-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'link_type2' => '2',
                ]
            ]
        );
        $this->add_control(
            'all_yearly_plan',
            [
                'label' => esc_html__( 'Add Yearly Plan', 'rola-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
            ]
        );
        $this-> end_controls_section();
        // End Yearly Plan controls

        // Start Style content controls
        $this-> start_controls_section(
            'pricing_tab_style',
            [
                'label'=>esc_html__('Pricing Tab', 'rola-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'tab_bg_color',
                [
                    'label' => esc_html__( 'Tab Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pricing-list-tab .tabs li a' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'tabtitle_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pricing-list-tab .tabs li a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tab_t_typo',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .pricing-list-tab .tabs li a',
                ]
            );

            $this->add_control(
                'tabact_bgcolor',
                [
                    'label' => esc_html__( 'Active Tab Background', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pricing-list-tab .tabs li.current a' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'tabact_color',
                [
                    'label' => esc_html__( 'Active Tab Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pricing-list-tab .tabs li.current a' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this-> end_controls_section();

        $this-> start_controls_section(
            'pricing_card_style',
            [
                'label'=>esc_html__('Pricing Card', 'rola-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'card_bg_color',
                [
                    'label' => esc_html__( 'Card Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'price_type',
                [
                    'label' => esc_html__( 'Pricing Type', 'rola-toolkit' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );
        
            $this->add_control(
                'type_color',
                [
                    'label' => esc_html__( 'Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table .pricing-header h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'price_typo',
                    'label'    => __( 'Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-pricing-table .pricing-header h3',
                ]
            );
            
            $this->add_control(
                'price_list',
                [
                    'label' => esc_html__( 'Pricing Feature List', 'rola-toolkit' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );
            $this->add_control(
                'price_list_color',
                [
                    'label' => esc_html__( 'Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table .pricing-features li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'price_listtypo',
                    'label'    => __( 'Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}}  .single-pricing-table .pricing-features li',
                ]
            );
            $this->add_control(
                'price_dlist_color',
                [
                    'label' => esc_html__( 'Disable Feature Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-pricing-table .pricing-features li.color-gray' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display(); 
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6';
        } else {
            $column = 'col-lg-3 col-sm-6';
        }
        
        ?>
        <!-- Start Pricing Area -->
        <div class="container">
            <div class="tab pricing-list-tab">
                <ul class="tabs"> 
                    <?php if( $settings['monthly_plan_text'] !='' ) : ?>
                        <li><a href="#">
                            <?php echo esc_html( $settings['monthly_plan_text']); ?>
                        </a></li> 
                    <?php endif;

                    if( $settings['yearly_plan_text'] !='' ) : ?>
                        <li><a href="#">
                            <?php echo esc_html( $settings['yearly_plan_text']); ?>
                        </a></li> 
                    <?php endif; ?>
                </ul>

                <div class="tab_content">
                    <!-- Start Monthly -->
                    <div class="tabs_item">
                        <div class="row"> 
                            <?php if ( $settings['all_monthly_plan']!='' ) :
                                $loop = 1;
                                foreach ( $settings['all_monthly_plan'] as $item ) :
        
                                    if($item['monthly_type']!='' || $item['monthly_price']!='') { 
                                        // Get Plan Button link
                                        $link_source = '';
                                        if($item['link_type'] == 1){
                                            $link_source = get_page_link($item['link_to_page']); 
                                        } else {
                                            $link_source = $item['external_link'];
                                        } ?>

                                        <div class="<?php echo esc_attr( $column ); ?>">
                                            <div class="single-pricing-table">
                                                <div class="pricing-header">
                                                    <h3><?php echo esc_html($item['monthly_type']); ?></h3>
                                                </div>

                                                <div class="price"><?php echo esc_html($item['monthly_price']); ?></div>

                                                <ul class="pricing-features">
                                                    <?php $lists = explode(',', $item['mon_price_list'] );
                                                    foreach (  $lists as $list ) : ?>
                                                        <?php if ( strpos( $list, "*" ) !== false ) : ?>
                                                            <li class="color-gray"><del> <?php echo str_replace('*', '', $list); ?></del></li>
                                                        <?php else: ?>
                                                            <li><?php echo esc_html( $list ); ?></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </ul>

                                                <?php if( $item['btn_text'] !='' ) : ?>
                                                    <div class="pricing-btn">
                                                        <a href="<?php echo esc_url($link_source); ?>" class="default-btn"><?php echo esc_html($item['btn_text']); ?></a>
                                                    </div>
                                                <?php  endif; ?>
                                            </div>
                                        </div>
                                    <?php } 
                                    $loop++; 
                                endforeach; 
                            endif; ?>
                        </div>
                    </div>
                    <!-- End Monthly -->

                    <!-- Start Yearly -->
                    <div class="tabs_item">
                        <div class="row"> 
                            <?php if ( $settings['all_yearly_plan']!='' ) :
                                $loop2 = 1;
                                foreach ( $settings['all_yearly_plan'] as $item2 ) :
        
                                    if($item2['yearly_type']!='' || $item2['yearly_price']!='') { 
                                        // Get Plan Button link
                                        $link_source2 = '';
                                        if($item2['link_type2'] == 1){
                                            $link_source2 = get_page_link($item2['link_to_page2']); 
                                        } else {
                                            $link_source2 = $item2['external_link2'];
                                        } ?>

                                        <div class="<?php echo esc_attr( $column ); ?>">
                                            <div class="single-pricing-table">
                                                <div class="pricing-header">
                                                    <h3><?php echo esc_html($item2['yearly_type']); ?></h3>
                                                </div>
                                                <div class="price"><?php echo esc_html($item2['yearly_price']); ?></div>

                                                <ul class="pricing-features">
                                                    <?php $lists = explode(",", $item2['year_price_list']);
                                                    foreach (  $lists as $list ) : ?>
                                                        <?php if ( strpos( $list, "*" ) !== false ) : ?>
                                                            <li class="color-gray"><del> <?php echo str_replace('*', '', $list); ?></del></li>
                                                        <?php else: ?>
                                                            <li> <?php echo esc_html( $list ); ?></li>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </ul>

                                                <?php if( $item2['year_btn_text'] !='' ) : ?>
                                                    <div class="pricing-btn">
                                                        <a href="<?php echo esc_url($link_source2); ?>" class="default-btn"><?php echo esc_html($item2['year_btn_text']); ?></a>
                                                    </div>
                                                    <?php 
                                                endif; ?>
                                            </div>
                                        </div>
                                    <?php } 
                                    $loop2++; 
                                endforeach; 
                            endif; ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    <?php
    } 

}
Plugin::instance()->widgets_manager->register_widget_type( new RolaPricingWidget );