<?php
/**
 * Section Widget
 */

namespace Elementor;
class Rola_Section extends Widget_Base {

	public function get_name() {
        return 'Rola_Section';
    }

	public function get_title() {
        return __( 'Section', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-handle';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_Section',
			[
				'label' => __( 'Section', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style one', 'rola-toolkit' ),
                        '2'   => __( 'Style two', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'icon',
                [
                    'label'      => __( ' Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'top_title', [
                    'label'       => __( 'Top Title', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'     => __( 'What Clients Say', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => __( 'What Clients Say', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'heading_tag', [
                    'label'   => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default'     => 'h2',
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'sec_desc',
                [
                    'label' => __('Description', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXTAREA,
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );

            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                        'choose_style' => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                        'choose_style' => '1',
                    ]
                ]
            );

            $this->add_control(
                'choose_left_col',
                [
                    'label' => __( 'Choose Left Content Column', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '12'   => __( 'Column 12(Full width)', 'rola-toolkit' ),
                        '11'   => __( 'Column 11', 'rola-toolkit' ),
                        '10'   => __( 'Column 10', 'rola-toolkit' ),
                        '9'    => __( 'Column 9', 'rola-toolkit' ),
                        '8'    => __( 'Column 8', 'rola-toolkit' ),
                        '7'    => __( 'Column 7', 'rola-toolkit' ),
                        '6'    => __( 'Column 6', 'rola-toolkit' ),
                        '5'    => __( 'Column 5', 'rola-toolkit' ),
                        '4'    => __( 'Column 4', 'rola-toolkit' ),
                        '3'    => __( 'Column 3', 'rola-toolkit' ),
                        '2'    => __( 'Column 2', 'rola-toolkit' ),
                    ],
                    'default'     => '7',
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title-warp .sub-title, .section-title .sub-title, .eye-care-solutions-area .section-title span, .skin-care-services-area .section-title span, .skin-care-before-after-area .section-title span, .skin-care-blog-area .section-title-warp .sub-title, .dental-tourism-services-area .section-title-warp .sub-title, .dental-tourism-dentist-area .section-title-warp .sub-title, .dental-tourism-review-area .section-title-warp .sub-title, .dental-tourism-blog-area .section-title-warp .sub-title, .skin-care-review-area .section-title-warp .sub-title, .skin-care-blog-area .section-title-warp .sub-title, .eye-care-team-area .section-title-warp .sub-title, .eye-care-blog-area .section-title-warp .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title-warp .sub-title i, .section-title .sub-title i, .eye-care-solutions-area .section-title span i, .skin-care-services-area .section-title span i, .skin-care-before-after-area .section-title span i, .skin-care-blog-area .section-title-warp .sub-title i, .dental-tourism-services-area .section-title-warp .sub-title i, .dental-tourism-dentist-area .section-title-warp .sub-title i, .dental-tourism-review-area .section-title-warp .sub-title i, .dental-tourism-blog-area .section-title-warp .sub-title i, .skin-care-review-area .section-title-warp .sub-title i, .skin-care-blog-area .section-title-warp .sub-title i, .eye-care-team-area .section-title-warp .sub-title i, .eye-care-blog-area .section-title-warp .sub-title i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => __( 'Top Title Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title-warp .sub-title, .section-title .sub-title, .skin-care-blog-area .section-title-warp .sub-title, .dental-tourism-services-area .section-title-warp .sub-title, .dental-tourism-dentist-area .section-title-warp .sub-title, .dental-tourism-review-area .section-title-warp .sub-title, .dental-tourism-blog-area .section-title-warp .sub-title, .skin-care-review-area .section-title-warp .sub-title, .skin-care-blog-area .section-title-warp .sub-title, .eye-care-team-area .section-title-warp .sub-title, .eye-care-blog-area .section-title-warp .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title-warp .sub-title, .section-title .sub-title, .skin-care-blog-area .section-title-warp .sub-title, .dental-tourism-services-area .section-title-warp .sub-title, .dental-tourism-dentist-area .section-title-warp .sub-title, .dental-tourism-review-area .section-title-warp .sub-title, .dental-tourism-blog-area .section-title-warp .sub-title, .skin-care-review-area .section-title-warp .sub-title, .skin-care-blog-area .section-title-warp .sub-title, .eye-care-team-area .section-title-warp .sub-title, .eye-care-blog-area .section-title-warp .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title-warp h2, .section-title-warp h1, .section-title-warp h3, .section-title-warp h4, .section-title-warp h5, .section-title-warp h6,  .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title-warp h2, .section-title-warp h1, .section-title-warp h3, .section-title-warp h4, .section-title-warp h5, .section-title-warp h6,  .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label'     => __( 'Description Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => __( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title p',
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Button link
        $btn_text  = $settings['button_text'];

        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        } 


        $choose_left_col  = $settings['choose_left_col'];
        if( $choose_left_col == '12' ){
            $left_col  = 'col-lg-12';
            $right_col = 'col-lg-12';
        } elseif( $choose_left_col == '11' ){
            $left_col  = 'col-lg-11';
            $right_col = 'col-lg-1';
        }  elseif( $choose_left_col == '10' ){
            $left_col  = 'col-lg-10';
            $right_col = 'col-lg-2';
        }  elseif( $choose_left_col == '9' ){
            $left_col  = 'col-lg-9';
            $right_col = 'col-lg-3';
        } elseif( $choose_left_col == '8' ){
            $left_col  = 'col-lg-8';
            $right_col = 'col-lg-4';
        } elseif( $choose_left_col == '7' ){
            $left_col  = 'col-lg-7';
            $right_col = 'col-lg-5';
        } elseif( $choose_left_col == '6' ){
            $left_col  = 'col-lg-6';
            $right_col = 'col-lg-6';
        }  elseif( $choose_left_col == '5' ){
            $left_col  = 'col-lg-5';
            $right_col = 'col-lg-7';
        } elseif( $choose_left_col == '4' ){
            $left_col  = 'col-lg-4';
            $right_col = 'col-lg-8';
        } elseif( $choose_left_col == '3' ){
            $left_col  = 'col-lg-3';
            $right_col = 'col-lg-9';
        } else {
            $left_col  = 'col-lg-2';
            $right_col = 'col-lg-10';
        } 

        ?>
        <?php if ( $settings['choose_style'] == '1' ) : ?>
            <div class="container">
                <div class="row align-items-center">
                    <div class="<?php echo esc_attr( $left_col ); ?>">
                        <div class="section-title-warp">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <?php if( $settings['icon'] != '' ) : ?>
                                        <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                                    <?php endif; ?>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['heading_tag'] ); ?>><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                        </div>
                    </div>

                    <?php if( $btn_text != '') : ?>
                        <div class="<?php echo esc_attr( $right_col ); ?>">
                            <div class="section-warp-btn">
                                <a href="<?php echo esc_url($link_one); ?>" class="default-btn"><?php echo esc_html( $btn_text ); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php else : ?>
            <div class="container">
                <div class="section-title">
                    <?php if( $settings['top_title'] != '' ) : ?>
                        <span class="sub-title">
                            <?php if( $settings['icon'] != '' ) : ?>
                                <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                            <?php endif; ?>
                            <?php echo esc_html( $settings['top_title'] ); ?>
                        </span>
                    <?php endif; ?>
                    <<?php echo esc_attr( $settings['heading_tag'] ); ?>><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                    <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Section );