<?php
/**
 * Skin Before After Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Before_After_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_BeforeAfter_Area';
    }

	public function get_title() {
        return esc_html__( 'Before After Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'Before After Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            // Left Content
            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'rola_be_after_items',
                [
                    'label'  => __( 'Add Before/After Image', 'parco-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings        = $this->get_settings_for_display();
        $be_after_items  = $settings['rola_be_after_items'];
    ?>
        <div class="container-fluid">
            <div class="skin-care-before-after-slides owl-carousel owl-theme">
                <?php foreach ( $be_after_items as $item ) : ?>
                    <?php if( $item['image']['url'] != '' ) : ?>
                        <div class="skin-care-before-after-card">
                            <img src="<?php echo esc_url( $item['image']['url']); ?>" alt="<?php echo esc_attr__('image','rola-toolkit'); ?>">
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Before_After_Area );