<?php
/**
 * Tourism Services Widget
 */

namespace Elementor;
class Rola_Tourism_Services extends Widget_Base {

	public function get_name() {
        return 'Tourism_Services_Area';
    }

	public function get_title() {
        return __( 'Tourism Services', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Tourism Services', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'header_size',
                [
                    'label' => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default' => 'h3',
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );

            /*
            $this->add_control(
                'excerpt_num',
                [
                    'label'   => __( 'Excerpt', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 14,
                ]
            );
            */

            $this->add_control(
                'cat_name',
                [
                    'label'   => __( 'Choose Category', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );

            $this->add_control(
				'pagination_show',
				[
					'label'        => __( 'Show Pagination?', 'rola-toolkit' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'rola-toolkit' ),
					'label_off'    => __( 'Hide', 'rola-toolkit' ),
					'return_value' => 'yes',
                    'default'      => 'no',
				]
            );
        $this->end_controls_section();
        
        // Style
        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-services-card .services-content h3 a, .dental-tourism-services-card .services-content h1 a, .dental-tourism-services-card .services-content h2 a, .dental-tourism-services-card .services-content h4 a, .dental-tourism-services-card .services-content h5 a, .dental-tourism-services-card .services-content h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_hcolor',
                [
                    'label'     => __( 'Title Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-services-card:hover .services-content h3 a, .dental-tourism-services-card:hover .services-content h1 a, .dental-tourism-services-card:hover .services-content h2 a, .dental-tourism-services-card:hover .services-content h4 a, .dental-tourism-services-card:hover .services-content h5 a, .dental-tourism-services-card:hover .services-content h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                     
                    'selector' => '{{WRAPPER}} .dental-tourism-services-card .services-content h3 a, .dental-tourism-services-card .services-content h1 a, .dental-tourism-services-card .services-content h2 a, .dental-tourism-services-card .services-content h4 a, .dental-tourism-services-card .services-content h5 a, .dental-tourism-services-card .services-content h6 a',
                ]
            );

            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-services-card .services-image .icon i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Icon Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-services-card .services-image .icon i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_hcolor',
                [
                    'label'     => __( 'Icon Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-services-card:hover .services-image .icon i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_hbgcolor',
                [
                    'label'     => __( 'Icon Hover Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-services-card:hover .services-image .icon i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        global $rola_opt;
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args ); ?>

        <div class="container-fluid">
            <div class="dental-tourism-services-slides owl-carousel owl-theme">
                <?php while( $services_array->have_posts() ): 
                $services_array->the_post();
                if ( class_exists('ACF') ) {
                    if ( get_field('choose_link_type') == 1 ) {
                        $post_link = get_the_permalink();
                    } else {
                        $post_link = get_field('external_link');
                    }
                    $icon = get_field('service_icon');
                } else {
                    $post_link = get_field('external_link');
                    $icon      = '';
                } ?>

                <div class="dental-tourism-services-card">
                    <div class="services-image">
                        <?php if( has_post_thumbnail() ) { ?>
                            <a href="<?php echo esc_url( $post_link ); ?>">
                                <img src="<?php the_post_thumbnail_url('rola_services_card_two') ?>" alt="<?php the_title_attribute(); ?>">
                            </a>
                        <?php } ?>

                        <?php if($icon != '') : ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr( $icon ); ?>"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="services-content">
                        <<?php echo esc_attr( $settings['header_size'] ); ?>>
                            <a href="<?php echo esc_url( $post_link ); ?>">
                                <?php the_title(); ?>
                            </a>
                        </<?php echo esc_attr( $settings['header_size'] ); ?>>
                    </div>
                </div>

                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
            
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Tourism_Services );