<?php 
namespace Elementor;
class RolaComingSoon extends Widget_Base{
    public function get_name(){
        return "Rola_Comingsoon";
    }
    public function get_title(){
        return "Coming Soon";
    }
    public function get_icon(){
        return 'eicon-tools';
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){
        // Start Left Content
        $this-> start_controls_section(
            'comingsoon_section',
            [
                'label' => __('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'logo_image',
                [
                    'label' => __( 'Logo Image', 'rola-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'   => __('Title','rola-toolkit'),
                    'type'    => Controls_Manager:: TEXTAREA,
                    'default' => __('We Are Launching Soon', 'rola-toolkit'),
                ]
            );
            $this->add_control(
                'rola_due_date',
                [
                    'label' => __( 'Due Date', 'rola' ),
                    'type' => Controls_Manager::DATE_TIME,
                    'default' => date( 'Y-m-d H:i', strtotime( '+1 month' ) + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ),
                    'description' => sprintf( __( 'Date set according to your timezone: %s.', 'rola' ), Utils::get_timezone_string() ),
                    
                ]
            );
            $this->add_control(
                'date', [
                    'label'       => __( 'Day Text', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Days' , 'rola-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'hours', [
                    'label'       => __( 'Hours Text', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Hours' , 'rola-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'minutes', [
                    'label'       => __( 'Minutes Text', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Minutes' , 'rola-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'seconds', [
                    'label'       => __( 'Seconds Text', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Seconds' , 'rola-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'emailtext',
                [
                    'label'      => __('Email Placeholder','rola-toolkit'),
                    'type'       => Controls_Manager:: TEXT,
                    'default'    => __('Enter your email','rola-toolkit'),
                ]
            );
            $this->add_control(
                'btn_text',
                [
                    'label' => __('Button Text','rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );

            $this->add_control(
                'action_url', [
                    'label' => esc_html__( 'Action URL', 'rola-toolkit' ),
                    'description' => __( 'Enter here your MailChimp action URL. <a href="https://www.docs.hibootstrap.com/docs/rola-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'rola-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => 'https://envytheme.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9
                    ',
                ]
            );
            
            $this->add_control(
                'image',
                [
                    'label' => __( 'Feature Image', 'rola-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
        $this-> end_controls_section();
        // End Right Content

        // Start Comingsoon Styling
        $this-> start_controls_section(
            'coming_style',
            [
                'label' => __('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'logo_color',
                [
                    'label'     => __( 'Logo Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-content h1 a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'logo_size',
                [
                    'label'  => __( 'Logo Font Size', 'rola-toolkit' ),
                    'type'   => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                    ],
                    'devices'   => [ 'desktop', 'tablet', 'mobile' ],
                    'unit'      => 'px',
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-content h1 a' => 'font-size: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-content h2' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'title_size',
                [
                    'label'  => __( 'Title Font Size', 'rola-toolkit' ),
                    'type'   => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                    ],
                    'devices'   => [ 'desktop', 'tablet', 'mobile' ],
                    'unit'      => 'px',
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-content h2' => 'font-size: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );
            $this->add_control(
                'time_bgcolor',
                [
                    'label'     => __( 'Timer Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-content #timer div' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'time_color',
                [
                    'label'     => __( 'Time Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-area .coming-soon-content #timer div' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'time_text_color',
                [
                    'label'     => __( 'Time Text Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .coming-soon-area .coming-soon-content #timer div span' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display(); 
        /*
        global $rola_opt;
        if(isset( $rola_opt['rola_due_date'] ) && $rola_opt['rola_due_date'] != '' ) {
            $cs_date =  $rola_opt['rola_due_date'];
        } else {
            $cs_date =  '';
        } 
        */
        
        $cs_date =  $settings['rola_due_date'];
        $cs_date =  preg_replace('/-/', '/', $cs_date);
        
        ?>

        <div class="coming-soon-area" style="background-image: url(<?php echo esc_url( $settings['image']['url']); ?> )">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="coming-soon-content">
                            <h1>
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo">
                                    <?php if( $settings['logo_image']['url'] != '' ) : ?>
                                        <img src="<?php echo esc_url( $settings['logo_image']['url']); ?>" alt="<?php echo esc_attr__('Logo image', 'rola-toolkit');  ?>">
                                    <?php else: ?>
                                        <?php bloginfo( 'name' ); ?>
                                    <?php endif; ?>
                                </a>
                            </h1>

                            <h2><?php echo esc_html( $settings['title'] ); ?></h2>

                            <div id="timer" class="flex-wrap d-flex justify-content-center">
                                <div id="days" class="align-items-center flex-column d-flex justify-content-center"></div>
                                <div id="hours" class="align-items-center flex-column d-flex justify-content-center"></div>
                                <div id="minutes" class="align-items-center flex-column d-flex justify-content-center"></div>
                                <div id="seconds" class="align-items-center flex-column d-flex justify-content-center"></div>
                            </div>

                            <form class="newsletter-form mailchimp" data-toggle="validator" method="post">
                                <div class="form-group">
                                    <input type="email" class="input-newsletter" placeholder="<?php echo esc_attr( $settings['emailtext'] );?>" name="EMAIL" required autocomplete="off">
                                </div>
                                
                                <?php if ( $settings['btn_text'] !='' ) : ?>
                                    <button type="submit" class="default-btn"><?php echo esc_html( $settings['btn_text'] );?></button> <?php
                                endif; ?>

                                <p class="mchimp-errmessage" style="display: none;"></p>
                                <p class="mchimp-sucmessage" style="display: none;"></p>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            (function($){
            "use strict";
                $( window ).on( 'elementor/frontend/init', function() {
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Rola_Comingsoon.default', function($scope, $){
                        // Count Time 
                        function makeTimer() {
                            var endTime = new Date("<?php echo $cs_date; ?>");	

                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400); 
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimer(); }, 300);
                        });

                });  

                if( typeof elementorFrontend !== 'undefined'  ){
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Rola_Comingsoon.default', function($scope, $){
                        // Count Time 
                        function makeTimerLive() {
                            var endTime = new Date("<?php echo $cs_date; ?>");

                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400); 
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimerLive(); }, 300);
                    });
                }
            
            }(jQuery));

        </script>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new RolaComingSoon );