<?php namespace Elementor;

class RolaContactWidget extends Widget_Base{
    public function get_name(){
        return "rolacontact-widget";
    }
    public function get_title(){
        return "Contact Widget";
    }
    public function get_icon(){
        return "eicon-form-horizontal";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        $this-> start_controls_section(
            'contact_info_content',
            [
                'label' => esc_html__('Contact Shortcode', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'contact_shortcode',
                [
                    'label' => esc_html__( 'Contact Form Shortcode', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXT,
                ]
            );

        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display(); 
        $form = $settings['contact_shortcode']; 
        ?>
        <div class="container">
           
            <?php if($form != '') : ?>
                <div class="contact-form">
                    <?php echo do_shortcode($form); ?>
                </div>
            <?php endif; ?>
        </div>

    <?php    
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new RolaContactWidget );