<?php
/**
 * Offer Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Offer_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_Offer_Area';
    }

	public function get_title() {
        return esc_html__( 'Offer Area', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_About_Area',
			[
				'label' => esc_html__( 'Offer Area', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'title1',
                [
                    'label'   => esc_html__( 'Title One', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'sec_desc',
                [
                    'label' => esc_html__( 'Description', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'title2',
                [
                    'label'   => esc_html__( 'Title Two', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'sec_desc2',
                [
                    'label' => esc_html__( 'Description 2', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'title3',
                [
                    'label'   => esc_html__( 'Title Three', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'sec_desc3',
                [
                    'label' => esc_html__( 'Description 3', 'rola-toolkit' ),
                    'type'  => Controls_Manager::TEXTAREA,
                ]
            );

            $this->add_control(
                'image',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
         
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title 1 Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-solutions-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-solutions-content h3',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description 1 Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-solutions-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => esc_html__( 'Description 1 Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-solutions-content p',
                ]
            );
            $this->add_control(
                't2_color',
                [
                    'label' => esc_html__( 'Title 2 Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-solutions-content .solutions-inner-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 't2_typography',
                    'label'    => esc_html__( 'Title 2 Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-solutions-content .solutions-inner-content h4',
                ]
            );
            $this->add_control(
                'desc2_color',
                [
                    'label' => esc_html__( 'Description 2 Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-solutions-content .solutions-inner-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc2_typography',
                    'label'    => esc_html__( 'Description 2 Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-solutions-content .solutions-inner-content p',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings    = $this->get_settings_for_display();
    ?>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-12">
                    <div class="eye-care-solutions-content">

                        <?php if( $settings['title1'] != '' ) : ?>
                            <h3><?php echo wp_kses_post( $settings['title1'] ); ?></h3>
                        <?php endif; ?>
                        <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                        <?php if( $settings['title2'] != '' || $settings['sec_desc2'] != '' ) : ?>
                        <div class="solutions-inner-content bg-F7F7FD">
                            <?php if( $settings['title2'] != '' ) : ?>
                                <h4><?php echo wp_kses_post( $settings['title2'] ); ?></h4>
                            <?php endif; ?>
                            <p><?php echo wp_kses_post( $settings['sec_desc2'] ); ?></p>
                        </div>
                        <?php endif; ?>

                        <?php if( $settings['title3'] != '' || $settings['sec_desc3'] != '' ) : ?>
                        <div class="solutions-inner-content">
                            <?php if( $settings['title3'] != '' ) : ?>
                                <h4><?php echo wp_kses_post( $settings['title3'] ); ?></h4>
                            <?php endif; ?>
                            <p><?php echo wp_kses_post( $settings['sec_desc3'] ); ?></p>
                        </div>
                        <?php endif; ?>

                    </div>
                </div>

                <?php if( $settings['image']['url'] != '') : ?>
                <div class="col-lg-6 col-md-12">
                    <div class="eye-care-solutions-image">
                        <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Offer_Area );