<?php
/**
 *  Feedback Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Rola_Feedback_Area extends Widget_Base {

	public function get_name() {
        return 'Rola_Feedback';
    }

	public function get_title() {
        return esc_html__( 'Feedback', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_feedback_section',
			[
				'label' => __( 'Feedback Controls' , 'rola' )
			]
        );
            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style one', 'rola-toolkit' ),
                        '2'   => __( 'Style two', 'rola-toolkit' ),
                        '3'   => __( 'Style three', 'rola-toolkit' ),
                        '4'   => __( 'Style four', 'rola-toolkit' ),
                        '5'   => __( 'Style five', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'icon',
                [
                    'label' => __( 'Quote Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $this->add_control(
                'rev_icon',
                [
                    'label'      => __( 'Review Star Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::TEXT,
                    'default'    => ' bx bxs-star',
                ]
            );

            $repeater_items = new Repeater();
            $repeater_items->add_control(
                'feedback',
                [
                    'label'   => esc_html__('Feedback Content', 'rola-toolkit'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas accumsan lacus vel facilisis.', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'client_img',
                [
                    'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $repeater_items->add_control(
                'name',
                [
                    'label'       => esc_html__('Name', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__('Olivar Lucy', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'rating',
                [
                    'label'       => esc_html__('Rating', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'designation',
                [
                    'label'       => esc_html__('Designation', 'rola-toolkit'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__('Designer', 'rola-toolkit'),
                    'label_block' => true,
                ]
            );

            
            $this->add_control(
                'rola_feedback_items',
                [
                    'label' => __( 'Add Item', 'parco-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );

            // Style 2
            $this->add_control(
                'columns',
                [
                    'label' => esc_html__( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => esc_html__( '1', 'rola-toolkit' ),
                        '2'   => esc_html__( '2', 'rola-toolkit' ),
                        '3'   => esc_html__( '3', 'rola-toolkit' ),
                        '4'   => esc_html__( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
		$this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => esc_html__( 'Style', 'rola-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'card_bgcolor',
                [
                    'label'     => esc_html__( 'Card Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-review-item, .dental-tourism-review-card, .skin-care-review-card' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => '3',
                    ]
                ]
            );
            $this->add_control(
                'card_bghcolor',
                [
                    'label'     => esc_html__( 'Card Background Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-review-card:hover' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '5',
                    ]
                ]
            );
            $this->add_control(
				'icon_color',
				[
					'label'     => esc_html__( 'Rating Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item .rating i, .dental-tourism-review-card .rating li i, .skin-care-review-card .rating li i' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style!' => '3',
                    ]
				]
			);
            $this->add_control(
				'icon_hcolor',
				[
					'label'     => esc_html__( 'Rating Hover Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .skin-care-review-card:hover .rating li i' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style' => '5',
                    ]
				]
			);
           
            $this->add_control(
				'feed_color',
				[
					'label'     => esc_html__( 'Feedback Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item p, .single-review-card p, .dental-tourism-review-card p, .skin-care-review-card p' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'feed_hcolor',
				[
					'label'     => esc_html__( 'Feedback Hover Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item:hover p, .single-review-card:hover p, .skin-care-review-card:hover p' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style!' => '4',
                    ]
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feed_typography',
                    'label'    => __( 'Feedback Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-review-item p, .single-review-card p, .dental-tourism-review-card p, .skin-care-review-card p',
                ]
            );
            $this->add_control(
				'name_color',
				[
					'label'     => esc_html__( 'Name Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item .review-info h3, .single-review-card .review-info h3, .dental-tourism-review-card .review-info h3, .skin-care-review-card .review-info h3' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'name_hcolor',
				[
					'label'     => esc_html__( 'Name Hover Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item:hover .review-info h3, .single-review-card:hover .review-info h3, .skin-care-review-card:hover .review-info h3' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style!' => '4',
                    ]
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'name_typography',
                    'label'    => __( 'Name Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-review-item .review-info h3, .single-review-card .review-info h3, .dental-tourism-review-card .review-info h3, .skin-care-review-card .review-info h3',
                ]
            );
            $this->add_control(
				'des_color',
				[
					'label'     => esc_html__( 'Designation Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item .review-info span, .single-review-card .review-info span, .dental-tourism-review-card .review-info span, .skin-care-review-card .review-info span' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'des_hcolor',
				[
					'label'     => esc_html__( 'Designation Hover Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-review-item:hover .review-info span, .single-review-card:hover .review-info span, .skin-care-review-card:hover .review-info span' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style!' => '4',
                    ]
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'des_typography',
                    'label'    => __( 'Designation Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-review-item .review-info span, .single-review-card .review-info span, .dental-tourism-review-card .review-info span, .skin-care-review-card .review-info span',
                ]
            );

            $this->add_control(
				'quo_color',
				[
					'label'     => esc_html__( 'Quote Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .skin-care-review-card .icon-quote i' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style' => '5',
                    ]
				]
			);
            $this->add_control(
				'quo_hcolor',
				[
					'label'     => esc_html__( 'Quote Hover Color', 'rola-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .skin-care-review-card:hover .icon-quote i' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'choose_style' => '5',
                    ]
				]
			);
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $slider   = $settings['rola_feedback_items'];
        $rev_icon = $settings['rev_icon'];

        // Card Columns
        $columns = $settings['columns'];
        if ($columns == '1') {
            $column = 'col-lg-12 col-md-6';
        }elseif ($columns == '2') {
            $column = 'col-lg-6 col-md-6';
        }elseif ($columns == '3') {
            $column = 'col-lg-4 col-md-6';
        }else{
            $column = 'col-lg-3 col-md-6';
        }
		?>

        <?php if ( $settings['choose_style'] == '1' ) : ?>
            <div class="container">
                <div class="review-slides owl-carousel owl-theme">
                    <?php foreach( $slider as $key => $value ) : ?>
                        <div class="single-review-item">

                            <div class="rating">
                                <?php for( $count = 1; $count <= $value['rating']; $count++ ){ ?>
                                    <i class="<?php echo esc_attr( $rev_icon ); ?>"></i>
                                <?php } ?>
                            </div>

                            <p><?php echo esc_html( $value['feedback'] ); ?></p>
                            <div class="review-info">
                                <?php if( $value['client_img']['url'] != '') : ?>
                                    <img src="<?php echo esc_url( $value['client_img']['url']); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                                <?php endif; ?>

                                <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                <span><?php echo esc_html( $value['designation'] ); ?></span>
                            </div>
                            <?php if( $settings['icon'] != '' ) : ?>
                                <div class="quote-icon">
                                    <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '2' ) : ?>
            <div class="container">
                <div class="row">
                    <?php foreach( $slider as $key => $value ) : ?>
                        <div class=" <?php echo esc_attr( $column );?> ">

                            <div class="single-review-item mb-30">
                                <?php if( $settings['icon'] != '' ) : ?>
                                    <div class="icon">
                                        <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                                    </div>
                                <?php endif; ?>
                                <p><?php echo esc_html( $value['feedback'] ); ?></p>

                                <div class="review-info">
                                    <?php if( $value['client_img']['url'] != '') : ?>
                                    <img src="<?php echo esc_url( $value['client_img']['url']); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                                    <?php endif; ?>

                                    <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                    <span><?php echo esc_html( $value['designation'] ); ?></span>
                                </div>
                            </div>

                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '3' ) : ?>
            <div class="container">
                <div class="review-slides-two owl-carousel owl-theme">
                    <?php foreach( $slider as $key => $value ) : ?>
                        <div class="single-review-card">
                            <?php if( $settings['icon'] != '' ) : ?>
                                <div class="icon">
                                    <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                                </div>
                            <?php endif; ?>
                            <p><?php echo esc_html( $value['feedback'] ); ?></p>

                            <div class="review-info">
                                <?php if( $value['client_img']['url'] != '') : ?>
                                <img src="<?php echo esc_url( $value['client_img']['url']); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                                <?php endif; ?>

                                <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                <span><?php echo esc_html( $value['designation'] ); ?></span>
                            </div>

                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style'] == '4' ) : ?>
            <div class="container">
                <div class="dental-tourism-review-slides owl-carousel owl-theme">
                    <?php foreach( $slider as $key => $value ) : ?>
                    <div class="dental-tourism-review-card">
                        <div class="review-info">
                            <?php if( $value['client_img']['url'] != '') : ?>
                                <img src="<?php echo esc_url( $value['client_img']['url']); ?>" class="rounded-circle" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                            <?php endif; ?>
                            <h3><?php echo esc_html( $value['name'] ); ?></h3>
                            <span><?php echo esc_html( $value['designation'] ); ?></span>
                        </div>
                        <p><?php echo esc_html( $value['feedback'] ); ?></p>
                        <ul class="rating">
                            <?php for( $count = 1; $count <= $value['rating']; $count++ ){ ?>
                                <li><i class="<?php echo esc_attr( $rev_icon ); ?>"></i> </li>
                            <?php } ?>
                        </ul>
                        <?php if( $settings['icon'] != '' ) : ?>
                            <div class="icon-quote">
                                <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="skin-care-review-slides owl-carousel owl-theme">
                    <?php foreach( $slider as $key => $value ) : ?>
                    <div class="skin-care-review-card">
                        <div class="review-info">
                            <?php if( $value['client_img']['url'] != '') : ?>
                                <img src="<?php echo esc_url( $value['client_img']['url']); ?>" class="rounded-circle" alt="<?php echo esc_attr__('image', 'rola-toolkit');?>">
                            <?php endif; ?>
                            <h3><?php echo esc_html( $value['name'] ); ?></h3>
                            <span><?php echo esc_html( $value['designation'] ); ?></span>
                        </div>
                        <p><?php echo esc_html( $value['feedback'] ); ?></p>
                        <ul class="rating">
                            <?php for( $count = 1; $count <= $value['rating']; $count++ ){ ?>
                                <li><i class="<?php echo esc_attr( $rev_icon ); ?>"></i> </li>
                            <?php } ?>
                        </ul>
                        <?php if( $settings['icon'] != '' ) : ?>
                            <div class="icon-quote">
                                <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Feedback_Area );