<?php
/**
 * Funfacts Widget
 */

namespace Elementor;
class Rola_Funfacts extends Widget_Base {

	public function get_name() {
        return 'Rola_Funfacts';
    }

	public function get_title() {
        return __( 'Funfacts', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-counter';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'funfacts_section',
			[
				'label' => __( 'Funfacts Control', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'rola-toolkit' ),
                'type'  => Controls_Manager::SELECT,
                'options' => [
                    '2'   => __( '2', 'rola-toolkit' ),
                    '3'   => __( '3', 'rola-toolkit' ),
                    '4'   => __( '4', 'rola-toolkit' ),
                ],
                'default' => '4',
            ]
        );
        
            $card_items = new Repeater();
            $card_items->add_control(
                'number',
                [
                    'type'    => Controls_Manager::NUMBER,
                    'label'   => __( 'Number', 'rola-toolkit' ),
                    'default' => 324,
                ]
            );
            $card_items->add_control(
                'sign_icon',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Suffix', 'rola-toolkit' ),
                    'default' => '%',
                ]
            );
            $card_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'rola-toolkit' ),
                    'default' => __('Clients Protection', 'rola-toolkit'),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'       => __( 'Add Item', 'rola-toolkit' ),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $card_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'counter_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'number_color',
                [
                    'label'     => __( 'Counter Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-fun-fact h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typo',
                    'label'    => __( 'Counter Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-fun-fact h3',
                ]
            );
            $this->add_control(
                'counter_title_color',
                [
                    'label'     => __( 'Counter Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-fun-fact p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'counter_title_typo',
                    'label'    => __( 'Counter Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-fun-fact p',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display(); 
        
        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-md-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-md-6 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        } else {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        } ?>
        <div class="container">
            <div class="row">
                <?php foreach ( $settings['items'] as $item ) :  ?>
                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="single-fun-fact">
                            <h3>
                                <span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span> 
                                <span class="sign-icon"><?php echo esc_html( $item['sign_icon'] ); ?></span>
                            </h3>

                            <p><?php echo esc_html( $item['title'] ); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_Funfacts );