<?php
/**
 * Skin Care Services Widget
 */

namespace Elementor;
class Rola_SkinCare_Services extends Widget_Base {

	public function get_name() {
        return 'SkinCare_Services_Area';
    }

	public function get_title() {
        return __( 'Care Services', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'services_section',
			[
				'label' => __( 'Care Services', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style one', 'rola-toolkit' ),
                        '2'   => __( 'Style two', 'rola-toolkit' ),
                        '3'   => __( 'Style three', 'rola-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'rola-toolkit' ),
                        '3'   => __( '3', 'rola-toolkit' ),
                        '4'   => __( '4', 'rola-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );

            $this->add_control(
                'header_size',
                [
                    'label' => __( 'Title Heading Tag', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default' => 'h3',
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Services Order By', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'rola-toolkit' ),
                        'ASC'       => __( 'ASC', 'rola-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );
            $this->add_control(
                'excerpt_num',
                [
                    'label'   => __( 'Excerpt', 'rola-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 14,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label'   => __( 'Choose Category', 'rola-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => rola_toolkit_get_page_services_cat_el(),
                ]
            );
        $this->end_controls_section();
        
        // Style
        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card .features-title h3 a, .skin-care-features-card .features-title h1 a, .skin-care-features-card .features-title h2 a, .skin-care-features-card .features-title h4 a, .skin-care-features-card .features-title h5 a, .skin-care-features-card .features-title h6 a, .skin-care-services-card .services-content h3 a, .skin-care-services-card .services-content h1 a, .skin-care-services-card .services-content h2 a, .skin-care-services-card .services-content h4 a, .skin-care-services-card .services-content h5 a, .skin-care-services-card .services-content h6 a, .eye-care-features-card .features-content h3 a, .eye-care-features-card .features-content h1 a, .eye-care-features-card .features-content h2 a, .eye-care-features-card .features-content h4 a, .eye-care-features-card .features-content h5 a, .eye-care-features-card .features-content h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_hcolor',
                [
                    'label'     => __( 'Title Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card:hover .features-title h3 a, .skin-care-features-card:hover .features-title h1 a, .skin-care-features-card:hover .features-title h2 a, .skin-care-features-card:hover .features-title h4 a, .skin-care-features-card:hover .features-title h5 a, .skin-care-features-card:hover .features-title h6 a, .skin-care-services-card:hover .services-content h3 a, .skin-care-services-card:hover .services-content h1 a, .skin-care-services-card:hover .services-content h2 a, .skin-care-services-card:hover .services-content h4 a, .skin-care-services-card:hover .services-content h5 a, .skin-care-services-card:hover .services-content h6 a' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => '3',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                     
                    'selector' => '{{WRAPPER}} .skin-care-features-card .features-title h3 a, .skin-care-features-card .features-title h1 a, .skin-care-features-card .features-title h2 a, .skin-care-features-card .features-title h4 a, .skin-care-features-card .features-title h5 a, .skin-care-features-card .features-title h6 a, .skin-care-services-card .services-content h3 a, .skin-care-services-card .services-content h1 a, .skin-care-services-card .services-content h2 a, .skin-care-services-card .services-content h4 a, .skin-care-services-card .services-content h5 a, .skin-care-services-card .services-content h6 a, .eye-care-features-card .features-content h3 a, .eye-care-features-card .features-content h1 a, .eye-care-features-card .features-content h2 a, .eye-care-features-card .features-content h4 a, .eye-care-features-card .features-content h5 a, .eye-care-features-card .features-content h6 a',
                ]
            );

            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Image Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card .features-title .icon-image' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
            $this->add_control(
                'ex_color',
                [
                    'label'     => __( 'Excerpt Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card p, .skin-care-services-card .services-content p, .eye-care-features-card .features-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'ex_hcolor',
                [
                    'label'     => __( 'Excerpt Hover Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card:hover p, .skin-care-services-card:hover .services-content p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => '3',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'ex_typography',
                    'label'    => __( 'Excerpt Typography', 'rola-toolkit' ),
                     
                    'selector' => '{{WRAPPER}} .skin-care-features-card p, .skin-care-services-card .services-content p, .eye-care-features-card .features-content p',
                ]
            );
            $this->add_control(
                'cardbgcolor',
                [
                    'label'     => __( 'Card Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card, .skin-care-services-card .services-content' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => '3',
                    ]
                ]
            );
            $this->add_control(
                'cardbghcolor',
                [
                    'label'     => __( 'Card Hover Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-features-card:hover, .skin-care-services-card:hover .services-content' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style!' => '3',
                    ]
                ]
            );

            $this->add_control(
                'card_iconcolor',
                [
                    'label'     => __( 'Card Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-services-card .services-image .icon i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'card_iconbgcolor',
                [
                    'label'     => __( 'Card Icon Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-services-card .services-image .icon i' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'card_hiconcolor',
                [
                    'label'     => __( 'Card Hover Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-services-card:hover .services-image .icon i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'card_hiconbgcolor',
                [
                    'label'     => __( 'Card Hover Icon Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .skin-care-services-card:hover .services-image .icon i' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'choose_style' => '2',
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        global $rola_opt;

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args ); ?>

        <?php if ( $settings['choose_style'] == '1' ) : ?>
        <div class="skin-care-features-area pt-100 pb-75">
            <div class="container">
                <div class="row justify-content-center">
                    <?php while( $services_array->have_posts() ): 
                    $services_array->the_post();
                    if ( class_exists('ACF') ) {
                        if ( get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('service_icon');

                        $card_img = get_field( 'sc_card_image' );
                    } else {
                        $post_link = get_field('external_link');
                        $icon      = '';
                        $card_img = '';
                    }
                    ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="skin-care-features-card">
                                <div class="features-title">
                                    <?php if( $card_img  != '') { ?>
                                        <div class="icon-image">
                                            <a href="<?php echo esc_url( $post_link ); ?>">
                                                <img src="<?php echo esc_url( $card_img  ); ?>" alt="<?php the_title_attribute(); ?>">
                                            </a>
                                        </div>
                                    <?php } ?>

                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>
                                </div>
                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
        <?php elseif ( $settings['choose_style'] == '2' ) : ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php while( $services_array->have_posts() ): 
                        $services_array->the_post();
                        if ( class_exists('ACF') ) {
                            if ( get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            $icon = get_field('service_icon');
                        } else {
                            $post_link = get_field('external_link');
                            $icon      = '';
                        }
                    ?>
                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="skin-care-services-card">
                            <div class="services-image">
                                <?php if( has_post_thumbnail() ) { ?>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <img src="<?php the_post_thumbnail_url('rola_services_card_two') ?>" alt="<?php the_title_attribute(); ?>">
                                    </a>
                                <?php } ?>
                                <?php if($icon != '') : ?>
                                    <div class="icon">
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="services-content">
                                <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </<?php echo esc_attr( $settings['header_size'] ); ?>>
                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endwhile;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        <?php else: ?>
            <div class="eye-care-features-area pt-100 pb-75">
                <div class="container">
                    <div class="row justify-content-center">
                    <?php while( $services_array->have_posts() ): 
                        $services_array->the_post();
                        if ( class_exists('ACF') ) {
                            if ( get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            $icon = get_field('service_icon');
                        } else {
                            $post_link = get_field('external_link');
                            $icon      = '';
                        }
                    ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="eye-care-features-card">
                                <?php if( has_post_thumbnail() ) { ?>
                                    <div class="features-image">
                                        <img src="<?php the_post_thumbnail_url('rola_services_card_three') ?>" alt="<?php the_title_attribute(); ?>">
                                    </div>
                                <?php } ?>

                                <div class="features-content">
                                    <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                        <a href="<?php echo esc_url( $post_link ); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </<?php echo esc_attr( $settings['header_size'] ); ?>>
                                    <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php endwhile;
                    wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_SkinCare_Services );