<?php namespace Elementor;

class RolaTourismTourist extends Widget_Base{
    public function get_name(){
        return "rola_TourismTourist";
    }
    public function get_title(){
        return "Tourism Tourist";
    }
    public function get_icon(){
        return "eicon-plus-square";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        $this-> start_controls_section(
            'tfeature_content',
            [
                'label' => esc_html__('Tourism Tourist', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'   => esc_html__( 'Title', 'rola-toolkit' ),
                'type'    => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'sec_desc',
            [
                'label' => esc_html__( 'Description', 'rola-toolkit' ),
                'type'  => Controls_Manager::TEXTAREA,
            ]
        );
        // Left Content
        $repeater_items = new Repeater();
        $repeater_items->add_control(
            'icon',
            [
                'label'    => __( 'Icon', 'rola-toolkit' ),
                'type' 	   => Controls_Manager::SELECT,
                'options'  => rola_icons(),
            ]
        );
        $repeater_items->add_control(
            'fea_title',
            [
                'label'       => __(' Title', 'rola-toolkit'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Free Shipping', 'rola-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'rola_left_items',
            [
                'label'  => __( 'Add Left Feature', 'parco-toolkit' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater_items->get_controls(),
            ]
        );

        // Right Content
        $repeater = new Repeater();
        $repeater->add_control(
            'image',
            [
                'label'  => esc_html__( 'Image', 'rola-toolkit' ),
                'type'	 => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'image_title',
            [
                'label' => esc_html__( 'Title', 'rola-toolkit' ),
                'type'  => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'rola_right_items',
            [
                'label'  => esc_html__( 'Add Tourist Image', 'rola-toolkit' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // Start Feature Style
        $this-> start_controls_section(
            'contact_style',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'info_title_color',
                [
                    'label' => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-tourists-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_title_typography',
                    'label'    => esc_html__( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-tourists-content h3',
                ]
            );
            $this->add_control(
                'info_con_color',
                [
                    'label' => esc_html__( 'Content Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-tourists-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_con_typography',
                    'label'    => esc_html__( 'Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-tourists-content p',
                ]
            );
            $this->add_control(
                'icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-tourists-content .list li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'info_list_color',
                [
                    'label' => esc_html__( 'Lists Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-tourists-content .list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_list_typography',
                    'label'    => esc_html__( 'Lists Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-tourists-content .list li',
                ]
            );
            $this->add_control(
                'img_title_color',
                [
                    'label' => esc_html__( 'Image Title Color', 'rola-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dental-tourism-tourists-image .tourists-image .content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'img_title_typography',
                    'label'    => esc_html__( 'Image Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .dental-tourism-tourists-image .tourists-image .content h3',
                ]
            );
        $this-> end_controls_section();
        
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        $left_items  = $settings['rola_left_items'];
        $right_items = $settings['rola_right_items'];
        ?>
        <div class="dental-tourism-tourists-area pb-75">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="dental-tourism-tourists-content">
                            <?php if( $settings['title'] != '' ) : ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>

                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>
    
                            <ul class="list">
                                <?php foreach( $left_items as $item ) : ?>
                                    <li>
                                        <?php if( $item['icon'] != '') : ?>
                                            <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                        <?php endif; ?>
                                        <?php echo esc_html( $item['fea_title'] ); ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12">
                        <div class="dental-tourism-tourists-image">
                            <div class="row">
                                <?php foreach ( $right_items as $item ) : ?>
                                    <div class="col-lg-4 col-sm-4 col-6">
                                        <div class="tourists-image">
                                            <?php if($item['image']['url'] !='') : ?>
                                                <img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                                            <?php endif; ?>
        
                                            <div class="content">
                                                <h3> <?php echo esc_html( $item['image_title'] ); ?></h3>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php    
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new RolaTourismTourist );