<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Rola
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function rola_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'article-sidebar' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'rola_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function rola_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'rola_pingback_header' );

 /*
 * Pagination
 */
if ( ! function_exists( 'rola_pagination' ) ) :
    function rola_pagination() {
    ?>
        <div class="pagination-area">
			<div class="nav-links">
				<?php echo paginate_links( array(
					'format' => '?paged=%#%',
					'prev_text' => '<i class="bx bx-left-arrow-alt"></i>',
					'next_text' => '<i class="bx bx-right-arrow-alt"></i>',
					)
				) ?>
			</div>
		</div>
    <?php
    }
endif;

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'rola_is_elementor' ) ) :
	function rola_is_elementor(){
		if ( function_exists( 'elementor_load_plugin_textdomain' ) ):
			global $post;
			return \Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID);
		endif;
	}
endif;

/**
 * Rola Main Logo
*/
if ( ! function_exists( 'main_logo' ) ) :
	function main_logo(){
		global $rola_opt;
		// rola Logo
		if ( isset( $rola_opt['main_logo']['url'] ) && $rola_opt['main_logo']['url'] !='' ) :
			$main_logo = $rola_opt['main_logo']['url'];
		else :
			$main_logo = 'null';
		endif;
		?>
			<?php if ( $main_logo != 'null' ) : ?>
				<img src="<?php echo esc_url( $main_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
			else : ?>
				<?php bloginfo( 'name' ); 
			endif; ?>
		<?php
	}
endif;

/**
 * Rola Footer Logo
 */
if ( ! function_exists( 'footer_logo' ) ) :
	function footer_logo(){
		global $rola_opt;
		// rola Logo
		if ( isset( $rola_opt['footer_logo']['url']) && $rola_opt['footer_logo']['url'] !='' ) :
			$rola_logo = $rola_opt['footer_logo']['url'];
		else :
			$rola_logo = 'null';
		endif;
		?>
			<?php if ( $rola_logo != 'null' ) : ?>
				<img src="<?php echo esc_url( $rola_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
			else : ?>
				<?php bloginfo( 'name' ); 
			endif; ?>
		<?php
	}
endif;

/**
 * Rola Mobile Logo
*/
if ( ! function_exists( 'mobile_logo' ) ) :
	function mobile_logo(){
		global $rola_opt;
		// Rola Logo
		if ( isset( $rola_opt['mobile_logo']['url']) && $rola_opt['mobile_logo']['url'] !='' ) :
			$rola_logo = $rola_opt['mobile_logo']['url'];
		else :
			$rola_logo = 'null';
		endif;
		?>
			<?php if ( $rola_logo != 'null' ) : ?>
				<img src="<?php echo esc_url($rola_logo); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
			else : ?>
				<?php bloginfo( 'name' );
			endif; ?>
		<?php
	}
endif;

// Search Overlay
if ( ! function_exists( 'rola_search' ) ) {
	function rola_search() { 
		global $rola_opt; 
		if( isset( $rola_opt['search_placeholder_text'] ) && $rola_opt['search_placeholder_text'] != '' ) {
			$rola_search_placeholder = $rola_opt['search_placeholder_text'];
		} else {
			$rola_search_placeholder = esc_html__('Search here', 'rola');
		} 
		
		$hide_wp_nav = 'hide-wp-nav'; ?>
		
		<div class="search-overlay <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_wp_nav ); } ?>">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="search-overlay-layer"></div>
                    <div class="search-overlay-layer"></div>
                    <div class="search-overlay-layer"></div>
                    
                    <div class="search-overlay-close">
                        <span class="search-overlay-close-line"></span>
                        <span class="search-overlay-close-line"></span>
                    </div>

                    <div class="search-overlay-form">
						<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
							<input type="text" class="input-search" placeholder="<?php echo esc_attr( $rola_search_placeholder ); ?>" value="<?php echo get_search_query(); ?>" name="s" id="s" required>
							<button type="submit"><i class="bx bx-search"></i></button>
						</form>
                    </div>
                </div>
            </div>
        </div>

		<?php
	}
}

/**
 * Estimated Reading Time
 */
if ( ! function_exists( 'rola_reading_time' ) ) :
	function rola_reading_time() {
		global $post;
		$thecontent  = get_post_field( 'post_content', $post->ID );
		$words 		 = str_word_count( strip_tags( $thecontent ) );
		$readingtime = ceil( $words / 200 );
		$output 	 = $readingtime;
		return $output;
	}
endif;

// Custom Service Search Result
if ( ! function_exists( 'rola_template_chooser' ) ) {
	function rola_template_chooser($template)   
	{    
		global $wp_query;   
		$post_type = get_query_var('post_type');   
		if( $wp_query->is_search && $post_type == 'service')   
		{
			if (!empty($post_type)){
				return locate_template('search-service.php');  //  redirect to search-service.php
			} else {
				return locate_template('content-none.php'); 
			}
		}
		return $template;
	}
}
add_filter('template_include', 'rola_template_chooser');

//Single Services Sidebar Title Active Class
if ( ! function_exists( 'rola_if_current' ) ) {
	function rola_if_current($active) {
		global $wp_query,$post;
		$current    = $wp_query->get_queried_object_id();
		$post_id    = $post->ID;
		if($current==$post_id){echo esc_attr($active, 'rola');}
	}
}

/**
 * Rola RTL
*/
if( ! function_exists( 'rola_rtl' ) ):
	function rola_rtl() {
		global $rola_opt;

		if(	isset( $rola_opt['rola_enable_rtl'])  ):
			$rola_rtl_opt = $rola_opt['rola_enable_rtl'];
		else:
			$rola_rtl_opt = 'disable';
		endif;

		if ( isset( $_GET['rtl'] ) ) {
			$rola_rtl_opt = $_GET['rtl'];
		}

		if ( $rola_rtl_opt == 'enable' ) :
			$rola_rtl = true;
		else:
			$rola_rtl = false;
		endif;

		return $rola_rtl;
	}
endif;


function rola_function_pcs() {
	$purchase_code = htmlspecialchars(get_option( 'rola_purchase_code' ));
	$purchase_code = str_replace(' ', '', $purchase_code);
	if( $purchase_code != '' ){
		require get_template_directory().'/inc/verify/class.verify-purchase.php';
		$o = EnvatoApi2::verifyPurchase( $purchase_code );

		if ( is_object($o) && strpos($o->item_name, 'Rola') !== false ) {

			// Check in localhost
			$whitelist = array(
				'127.0.0.1',
				'::1',
				'192.168.1',
				'192.168.0.1',
				'182.168.1.5',
				'192.168.1.4',
				'192.168.1.5',
				'192.168.1.4',
				'192.168',
				'10.0.2.2',
			);

			if(!in_array($_SERVER['REMOTE_ADDR'], $whitelist)){ // In server
				$url 			= 'https://api.envytheme.com/api/v1/license';
				$purchaseKey 	= $purchase_code;
				$itemName 		= $o->item_name;
				$buyer 			= $o->buyer;
				$purchasedAt 	= $o->created_at;
				$supportUntil 	= $o->supported_until;
				$licenseType 	= $o->licence;
				$domain 		= get_site_url();
				$post_url 		= '';

				$post_url .= $url.'?purchaseKey='.$purchaseKey.'&itemName='.$itemName.'&buyer='.$buyer.'&purchasedAt='.$purchasedAt.'&supportUntil='.$supportUntil.'&licenseType='.$licenseType.'&domain='.$domain.'';

				$post_url = str_replace(' ', '%', $post_url);

				$curl = curl_init();

				curl_setopt_array($curl, array(
					CURLOPT_URL 			=> $post_url,
					CURLOPT_RETURNTRANSFER 	=> true,
					CURLOPT_ENCODING 		=> "",
					CURLOPT_MAXREDIRS		=> 10,
					CURLOPT_TIMEOUT 		=> 30,
					CURLOPT_HTTP_VERSION 	=> CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST 	=> "POST",
					CURLOPT_HTTPHEADER 		=> array(
						"cache-control: no-cache",
						"content-type: application/x-www-form-urlencoded"
					),
					CURLOPT_SSL_VERIFYPEER => false,
				));

				$response = curl_exec($curl);
				$err = curl_error($curl);
				curl_close($curl);

				if ($err) {
					echo "cURL Error #:" . $err;
				} else {
					$json = json_decode($response);
					$already_registered = $json->message[0]; // Already registered

					$new_response = '';
					$new_response .= 'Congratulations! Updated for this domain '.$domain.'';
					preg_match_all('#https?://[^,\s()<>]+(?:\([\w\d]+\)|([^,[:punct:]\s]|/))#', $already_registered, $match);
					$url 			= $match[0];
					$protocols 		= array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
					$domain_name 	= str_replace( $protocols, '', $url[0] );
					$site_url 		= str_replace( $protocols, '', get_site_url() );

					if( $already_registered != '' ){
						if( $already_registered == $new_response ):
							update_option('rola_purchase_code_status', 'valid', 'yes');
							update_option('rola_purchase_valid_code',  $purchase_code, 'yes');
							update_option('rola_valid_url',  $domain, 'yes');
							update_option('valid_url', get_site_url(), 'yes');
							?><script>let date = new Date(Date.now() + 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
						elseif( $domain_name == $site_url ):
							/* Deregister  */
								$url 			= 'https://api.envytheme.com/api/v1/license';
								$purchaseKey 	= $purchase_code;
								$status 		= 'disabled';
								$post_url = '';
								$post_url .= $url.'?purchaseKey='.$purchaseKey.'&status='.$status.'';
								$post_url = str_replace(' ', '%', $post_url);
								$curl = curl_init();
								curl_setopt_array($curl, array(
									CURLOPT_URL 			=> $post_url,
									CURLOPT_RETURNTRANSFER 	=> true,
									CURLOPT_ENCODING 		=> "",
									CURLOPT_MAXREDIRS 		=> 10,
									CURLOPT_TIMEOUT 		=> 30,
									CURLOPT_HTTP_VERSION 	=> CURL_HTTP_VERSION_1_1,
									CURLOPT_CUSTOMREQUEST 	=> "PUT",
									CURLOPT_HTTPHEADER 		=> array(
										"cache-control: no-cache",
										"content-type: application/x-www-form-urlencoded"
									),
									CURLOPT_SSL_VERIFYPEER => false,
								));

								$response = curl_exec($curl);
								$err = curl_error($curl);
								curl_close($curl);
							/* Deregister */

							/* Register */
								$url 			= 'https://api.envytheme.com/api/v1/license';
								$purchaseKey 	= $purchase_code;
								$itemName 		= $o->item_name;
								$buyer 			= $o->buyer;
								$purchasedAt 	= $o->created_at;
								$supportUntil 	= $o->supported_until;
								$licenseType 	= $o->licence;
								$domain 		= get_site_url();
								$post_url 		= '';

								$post_url .= $url.'?purchaseKey='.$purchaseKey.'&itemName='.$itemName.'&buyer='.$buyer.'&purchasedAt='.$purchasedAt.'&supportUntil='.$supportUntil.'&licenseType='.$licenseType.'&domain='.$domain.'';

								$post_url = str_replace(' ', '%', $post_url);

								$curl = curl_init();

								curl_setopt_array($curl, array(
								CURLOPT_URL => $post_url,
								CURLOPT_RETURNTRANSFER => true,
								CURLOPT_ENCODING => "",
								CURLOPT_MAXREDIRS => 10,
								CURLOPT_TIMEOUT => 30,
								CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								CURLOPT_CUSTOMREQUEST => "POST",
								CURLOPT_HTTPHEADER => array(
									"cache-control: no-cache",
									"content-type: application/x-www-form-urlencoded"
								),
								CURLOPT_SSL_VERIFYPEER => false,
								));

								$response = curl_exec($curl);
								$err = curl_error($curl);
								curl_close($curl);
							/* Register */

							update_option('rola_purchase_code_status', 'valid', 'yes');
							update_option('rola_purchase_valid_code',  $purchase_code, 'yes');
							update_option('rola_valid_url',  $domain, 'yes');
							update_option('valid_url', get_site_url(), 'yes');
							?><script>let date = new Date(Date.now() + 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
						else:
							$target_site 	= $url[0];
							$src 			= file_get_contents( $target_site );
							preg_match("/\<link rel='stylesheet' id='rola-style-css'.*href='(.*?style\.css.*?)'.*\>/i", $src, $matches );

							if( $matches ) { // if theme found
								update_option('rola_purchase_code_status', 'already_registered', 'yes');
								update_option('rola_already_registered', $already_registered, 'yes');
							}else{
								/* Deregister  */
									$url 			= 'https://api.envytheme.com/api/v1/license';
									$purchaseKey 	= $purchase_code;
									$status 		= 'disabled';
									$post_url = '';
									$post_url .= $url.'?purchaseKey='.$purchaseKey.'&status='.$status.'';
									$post_url = str_replace(' ', '%', $post_url);
									$curl = curl_init();
									curl_setopt_array($curl, array(
										CURLOPT_URL 			=> $post_url,
										CURLOPT_RETURNTRANSFER 	=> true,
										CURLOPT_ENCODING 		=> "",
										CURLOPT_MAXREDIRS 		=> 10,
										CURLOPT_TIMEOUT 		=> 30,
										CURLOPT_HTTP_VERSION 	=> CURL_HTTP_VERSION_1_1,
										CURLOPT_CUSTOMREQUEST 	=> "PUT",
										CURLOPT_HTTPHEADER 		=> array(
											"cache-control: no-cache",
											"content-type: application/x-www-form-urlencoded"
										),
										CURLOPT_SSL_VERIFYPEER => false,
									));

									$response = curl_exec($curl);
									$err = curl_error($curl);
									curl_close($curl);
								/* Deregister */

								/* Register */
									$url 			= 'https://api.envytheme.com/api/v1/license';
									$purchaseKey 	= $purchase_code;
									$itemName 		= $o->item_name;
									$buyer 			= $o->buyer;
									$purchasedAt 	= $o->created_at;
									$supportUntil 	= $o->supported_until;
									$licenseType 	= $o->licence;
									$domain 		= get_site_url();
									$post_url 		= '';

									$post_url .= $url.'?purchaseKey='.$purchaseKey.'&itemName='.$itemName.'&buyer='.$buyer.'&purchasedAt='.$purchasedAt.'&supportUntil='.$supportUntil.'&licenseType='.$licenseType.'&domain='.$domain.'';

									$post_url = str_replace(' ', '%', $post_url);

									$curl = curl_init();

									curl_setopt_array($curl, array(
									CURLOPT_URL => $post_url,
									CURLOPT_RETURNTRANSFER => true,
									CURLOPT_ENCODING => "",
									CURLOPT_MAXREDIRS => 10,
									CURLOPT_TIMEOUT => 30,
									CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
									CURLOPT_CUSTOMREQUEST => "POST",
									CURLOPT_HTTPHEADER => array(
										"cache-control: no-cache",
										"content-type: application/x-www-form-urlencoded"
									),
									CURLOPT_SSL_VERIFYPEER => false,
									));

									$response = curl_exec($curl);
									$err = curl_error($curl);
									curl_close($curl);
								/* Register */
							}
						endif;
					}else {
						update_option('rola_purchase_code_status', 'valid', 'yes');
						update_option('rola_purchase_valid_code',  $purchase_code, 'yes');
						update_option('rola_valid_url',  $domain, 'yes');
						update_option('valid_url', get_site_url(), 'yes');
						?><script>let date = new Date(Date.now() + 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
					}

				}

			}else{ // In local
				$domain = get_site_url();
				update_option('rola_purchase_code_status', 'valid', 'yes');
				update_option('rola_purchase_valid_code',  $purchase_code, 'yes');
				update_option('rola_valid_url',  $domain, 'yes');
			}
		} elseif( $purchase_code == '' ){
			update_option( 'rola_purchase_code_status', '', 'yes' );
			update_option( 'rola_purchase_code', '', 'yes' );
		}
	}
}

add_action( 'admin_bar_menu', 'rola_header_options', 500 );
function rola_header_options ( WP_Admin_Bar $admin_bar ) {
    global $wp;
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

	if ( strpos($actual_link, 'themes.hibootstrap.com/rola') != false ):
		update_option('rola_purchase_code_status', 'valid', 'yes');
	endif;

	if ( $actual_link == home_url('/wp-admin/admin.php?page=rola') ){
		return '';
	}else{
		$site_url 	= get_site_url();
		$valid_url 	= get_option( 'valid_url' );
		$purchase_code = get_option( 'rola_purchase_valid_code' );

		if( current_user_can('administrator') ) {
			if(!isset($_COOKIE['ET_L_Status'])) {
				rola_function_pcs();
			}elseif( $site_url !=  $valid_url) {
				rola_function_pcs();
			}else{
				?><script>let date = new Date(Date.now() - 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
			}
		}
	}
}