<?php
/**
 * The template for displaying search results pages
 * @package rola
 */
get_header();

// Blog Sidebar
if( isset( $rola_opt['rola_service_sidebar'] ) ) {
    if( $rola_opt['rola_service_sidebar'] == 'rola_without_sidebar_center' ) :
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $rola_opt['rola_service_sidebar'] == 'rola_without_sidebar' ) :
        $rola_sidebar_class = 'col-lg-12 col-md-12';
    else:
        $rola_sidebar_class = 'col-lg-8 col-md-12';
    endif;
    $sidebar_hide           = $rola_opt['rola_service_sidebar'];
} else {
    $rola_sidebar_class         = 'col-lg-8 col-md-12';
    $sidebar_hide               = 'rola_with_sidebar';
}
?>

<!-- Start Page Title Area -->
<div class="page-banner-area">
    <div class="container">
        <div class="page-banner-content text-center">
            <h2><?php printf( esc_html__( 'Search Results for: %s', 'rola' ), '<span>' . get_search_query() . '</span>' ); ?></h2>
        </div>
    </div>
</div>

<!-- Start Blog Area -->
<div class="blog-area ptb-100">
    <div class="container">
        <div class="row">
            <!-- Start Blog Content -->
            <div class="<?php echo esc_attr( $rola_sidebar_class ); ?>">
                <?php
                if ( have_posts() ) :
                    while ( have_posts() ) : the_post();
                        if(isset($_GET['post_type'])) {
                            $type = $_GET['post_type'];
                            if($type == 'service') {
                                get_template_part( 'template-parts/content', get_post_format());
                            } else {
                                get_template_part( 'template-parts/content', get_post_format());
                            }
                            
                        } else {
                            get_template_part( 'template-parts/content', get_post_format());
                        }
                    endwhile;

                else :
                    get_template_part( 'template-parts/content', 'none' );
                endif;

                ?>
        
                <!-- Stat Pagination -->
                <?php rola_pagination(); ?>

            </div>
            
            <?php if( $sidebar_hide == 'rola_with_sidebar' ) :
                get_template_part('template-parts/cus-service','sidebar');
            endif; ?>
        </div>   
    </div>
</div>
<!-- End Blog Area -->
<?php
get_footer();