<?php global $rola_opt;
/**
 * @package Rola
*/

$hide_top_header 	   = !empty($rola_opt['hide_top_header']) ? $rola_opt['hide_top_header'] : false;
$top_social_link 	   = !empty($rola_opt['top_social_link']) ? $rola_opt['top_social_link'] : false;

$top_header_text       = !empty($rola_opt['top_header_text']) ? $rola_opt['top_header_text'] : '';
$top_header_text_icon  = !empty($rola_opt['top_header_text_icon']) ? $rola_opt['top_header_text_icon'] : '';

$top_header_mail       = !empty($rola_opt['top_header_mail']) ? $rola_opt['top_header_mail'] : '';
$top_header_mail_link  = !empty($rola_opt['top_header_mail_link']) ? $rola_opt['top_header_mail_link'] : '';
$top_header_mail_icon  = !empty($rola_opt['top_header_mail_icon']) ? $rola_opt['top_header_mail_icon'] : '';

$top_header_num       = !empty($rola_opt['top_header_num']) ? $rola_opt['top_header_num'] : '';
$top_header_num_link  = !empty($rola_opt['top_header_num_link']) ? $rola_opt['top_header_num_link'] : '';
$top_header_num_icon  = !empty($rola_opt['top_header_num_icon']) ? $rola_opt['top_header_num_icon'] : '';

$app_btn_text         = !empty($rola_opt['app_btn_text']) ? $rola_opt['app_btn_text'] : '';

$enable_app_button 		= !empty($rola_opt['enable_app_button']) ? $rola_opt['enable_app_button'] : '';
$header_btn_link_type       = !empty($rola_opt['header_btn_link_type']) ? $rola_opt['header_btn_link_type'] : '';
$header_btn_link_external	= !empty($rola_opt['header_btn_link_external']) ? $rola_opt['header_btn_link_external'] : '';
$header_btn_internal 		= !empty($rola_opt['header_btn_internal']) ? $rola_opt['header_btn_internal'] : '';
$enable_search 		        = !empty($rola_opt['enable_search']) ? $rola_opt['enable_search'] : false;

if( function_exists('acf_add_options_page') && get_field( 'choose_nav_width' ) != '' ) {
    $nav_width          = get_field( 'choose_nav_width' );
} else {
    $nav_width          = 'container-fluid';
}

// WP admin bar
$hide_wp_nav = 'hide-wp-nav';

?>


<?php if( $hide_top_header ==  true ) : ?>
    <div class="top-header-area">
        <div class="<?php echo esc_attr($nav_width); ?>">
            <div class="row align-items-center">
                <?php if( $top_header_text != '' ||  $top_header_mail  != '' ||  $top_header_num  != '') : ?>
                    <div class="col-lg-7 col-md-12">
                        <ul class="top-header-information">

                            <?php if( $top_header_num != '' ) : ?>
                                <li>
                                    <i class='<?php echo esc_attr( $top_header_num_icon ); ?>'></i>
                                    <a href="<?php echo esc_url( $top_header_num_link ); ?>"> <?php echo esc_html( $top_header_num ); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if( $top_header_text != '' ) : ?>
                                <li>
                                    <i class='<?php echo esc_attr( $top_header_text_icon ); ?>'></i>
                                    <?php echo esc_html( $top_header_text ); ?>
                                </li>
                            <?php endif; ?>

                            <?php if( $top_header_mail  != '' ) : ?>
                                <li>
                                    <i class='<?php echo esc_attr( $top_header_mail_icon ); ?>'></i>
                                    <a href="<?php echo esc_url( $top_header_mail_link ); ?>"><?php echo esc_html( $top_header_mail ); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php if( $top_social_link !=  true ) : ?>
                    <div class="col-lg-5 col-md-12">
                        <ul class="top-header-optional">
                            <?php rola_social_link(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Start Navbar Area -->
<div class="navbar-area <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_wp_nav ); } ?>">

    <div class="main-responsive-nav">
        <div class="container">
            <div class="main-responsive-menu">
                <h1>
                    <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php mobile_logo(); ?>
                    </a>
                </h1>
            </div>
        </div>
    </div>

    <div class="main-navbar">
        <div class="<?php echo esc_attr($nav_width); ?>">
            <nav class="navbar navbar-expand-md navbar-light">
                <h1>
                    <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php main_logo(); ?>
                    </a>
                </h1>

                <div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
                    <?php $primary_nav_arg = [
                            'menu'            => 'primary',
                            'theme_location'  => 'primary',
                            'container'       => null,
                            'menu_class'      => 'navbar-nav ms-auto',
                            'depth'           => 3,
                            'walker'          => new Rola_Bootstrap_Navwalker(),
                            'fallback_cb'     => 'Rola_Bootstrap_Navwalker::fallback',
                        ];
                
                        if ( has_nav_menu('primary') ) :
                            wp_nav_menu( $primary_nav_arg );
                        endif;
                    ?>

                    <div class="others-options d-flex align-items-center">
                        <?php if( $enable_search == true  ) : ?>
                            <div class="option-item">
                                <a class="search-box" href="#"><i class='bx bx-search'></i></a>
                            </div>
                        <?php endif; ?>

                        <?php if( $enable_app_button == true && $app_btn_text != '') : ?>
                            <div class="option-item">
                                <?php if( $app_btn_text != '' ) : ?>
                                
                                    <?php if( $header_btn_link_type == 'external_link' ): ?>
                                        <a href="<?php echo esc_url( $header_btn_link_external ); ?>" class="default-btn"> <?php echo esc_html( $app_btn_text ); ?> </a>
                                    <?php elseif( $header_btn_link_type == 'internal_link' ): ?>
                                        <a href="<?php echo esc_url( home_url( $header_btn_internal ) ); ?>" class="default-btn"> <?php echo esc_html( $app_btn_text ); ?> </a>
                                    <?php endif; ?>

                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </nav>
        </div>
    </div>

    <?php if( $enable_search == true || $enable_app_button == true ) : ?>
        <div class="others-option-for-responsive">
            <div class="container">
                <div class="dot-menu">
                    <div class="inner">
                        <div class="circle circle-one"></div>
                        <div class="circle circle-two"></div>
                        <div class="circle circle-three"></div>
                    </div>
                </div>
                <div class="container">
                    <div class="option-inner">
                        <div class="others-options d-flex align-items-center">
                            <?php if( $enable_search == true  ) : ?>
                                <div class="option-item">
                                    <a class="search-box" href="#">
                                        <i class="bx bx-search"></i>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <?php if( $enable_app_button == true && $app_btn_text != '') : ?>
                                <div class="option-item">

                                    <?php if( $app_btn_text != '' ) : ?>
                                        <?php if( $header_btn_link_type == 'external_link' ): ?>
                                            <a href="<?php echo esc_url( $header_btn_link_external ); ?>" class="default-btn"> <?php echo esc_html( $app_btn_text ); ?> </a>
                                        <?php elseif( $header_btn_link_type == 'internal_link' ): ?>
                                            <a href="<?php echo esc_url( home_url( $header_btn_internal ) ); ?>" class="default-btn"> <?php echo esc_html( $app_btn_text ); ?> </a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>