<?php
namespace Elementor;
class Rola_BannerThree_Slider extends Widget_Base{
    public function get_name(){
        return "rola-banner-three";
    }
    public function get_title(){
        return "Banner Three";
    }
    public function get_icon(){
        return "eicon-banner";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

            $this->add_control(
                'header_size',
                [
                    'label' => __('Title Heading Tag', 'rola-toolkit'),
                    'type' => Controls_Manager::SELECT,
                        'options' => [
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'h4' => 'H4',
                            'h5' => 'H5',
                            'h6' => 'H6',
                        ],
                    'default'     => 'h1',
                    'label_block' => true,
                ]
            );

            $repeater_items = new Repeater();

            $repeater_items->add_control(
                'bg_image',
                [
                    'label' => __( 'Image', 'rola-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $repeater_items->add_control(
                'sub_icon',
                [
                    'label'      => __( 'Icon', 'rola-toolkit' ),
                    'type' 	     => Controls_Manager::SELECT,
                    'options'    => rola_icons(),
                ]
            );
            $repeater_items->add_control(
                'sub_title',
                [
                    'label'   => __( 'Sub Title', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('Basic', 'rola-toolkit'),
                ]
            );
            $repeater_items->add_control(
                'banner_title',
                [
                    'label'       => __('Title', 'rola-toolkit'),
                    'type'        => Controls_Manager:: TEXTAREA,
                    'label_block' => true,
                ]
            );
            $repeater_items->add_control(
                'desc',
                [
                    'label'  => __('Description', 'rola-toolkit'),
                    'type'   => Controls_Manager:: TEXTAREA,
                ]
            );
            $repeater_items->add_control(
                'button_one_text',
                [
                    'label' => __('Button One Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $repeater_items->add_control(
                'link_type',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $repeater_items->add_control(
                'link_to_page',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type' => '1',
                    ]
                ]
            );
            $repeater_items->add_control(
                'external_link',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

            $repeater_items->add_control(
                'div1',
                [
                    'type'  => Controls_Manager:: DIVIDER,
                ]
            );

            // Button Two
            $repeater_items->add_control(
                'button_two_text',
                [
                    'label' => __('Button Two Text', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                ]
            );
            $repeater_items->add_control(
                'link_type2',
                [
                    'label' => __( 'Link Type', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'   => __( 'Link To Page', 'rola-toolkit' ),
                        '2'   => __( 'External Link', 'rola-toolkit' ),
                    ],
                ]
            );
            $repeater_items->add_control(
                'link_to_page2',
                [
                    'label' => __( 'Link Page', 'rola-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => rola_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type2' => '1',
                    ]
                ]
            );
            $repeater_items->add_control(
                'external_link2',
                [
                    'label' => __('External Link', 'rola-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type2' => '2',
                    ]
                ]
            );

            $this->add_control(
                'rola_banner_items',
                [
                    'label'  => __( 'Add Item', 'rola-toolkit' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater_items->get_controls(),
                ]
            );
        $this-> end_controls_section();

        // End Tab content controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label' => __('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content .sub-title i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_bgcolor',
                [
                    'label' => esc_html__( 'Top Title Background Color', 'rola-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_top_title',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .main-slides-content .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content h1, .main-slides-content h2, .main-slides-content h3, .main-slides-content h4, .main-slides-content h5, .main-slides-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color_color',
                [
                    'label'     => esc_html__( 'Color Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content h1 span, .main-slides-content h2 span, .main-slides-content h3 span, .main-slides-content h4 span, .main-slides-content h5 span, .main-slides-content h6 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_title',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .main-slides-content h1, .main-slides-content h2, .main-slides-content h3, .main-slides-content h4, .main-slides-content h5, .main-slides-content h6',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label'     => esc_html__( 'Description Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content p, .main-slides-content ul li, .main-slides-content ol li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_desc',
                    'label'    => __( 'Description Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .main-slides-content p, .main-slides-content ul li, .main-slides-content ol li',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => esc_html__( 'Button One Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_btn',
                    'label'    => __( 'Button One Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .default-btn',
                ]
            );

            $this->add_control(
                'btn2_color',
                [
                    'label'     => esc_html__( 'Button Two Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slides-content .slides-btn .optional-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_btn2',
                    'label'    => __( 'Button Two Typography', 'rola-toolkit' ),
                    'selector' => ' {{WRAPPER}} .main-slides-content .slides-btn .optional-btn',
                ]
            );
        $this-> end_controls_section();
        // End Style content controls
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        $slider   = $settings['rola_banner_items']; 
        
        ?>

        <div class="home-slides owl-carousel owl-theme">
            <?php foreach( $slider as $key => $value ) : 
                // Button link
                $btn1_text  = $value['button_one_text'];
                $btn2_text  = $value['button_two_text'];

                $link_one = '';
                if( $value['link_type'] == 1 ){
                    $link_one = get_page_link($value['link_to_page']); 
                } else {
                    $link_one = $value['external_link'];
                } 

                $link_two = '';
                if( $value['link_type2'] == 1 ){
                    $link_two = get_page_link($value['link_to_page2']); 
                } else {
                    $link_two = $value['external_link2'];
                }
            ?>
                <div class="main-slides-item" style="background-image: url(<?php echo esc_url( $value['bg_image']['url']); ?> )">
                    <div class="container">
                        <div class="main-slides-content">
                            <?php if( $value['sub_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <i class=" <?php echo esc_attr( $value['sub_icon'] ); ?>"></i>
                                    <?php echo esc_html( $value['sub_title'] ); ?>
                                </span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['header_size'] ); ?>>
                                <?php echo wp_kses_post( $value['banner_title'] ); ?>
                            </<?php echo esc_attr( $settings['header_size'] ); ?>>

                            <p><?php echo wp_kses_post( $value['desc'] ); ?></p>

                            <?php if( $btn1_text != '' || $btn2_text != '' ) : ?>
                                <div class="slides-btn">
                                    <?php if( $btn1_text != '' ): ?>
                                        <a href="<?php echo esc_url($link_one); ?>" class="default-btn"> <?php echo esc_html( $btn1_text ); ?></a>
                                    <?php endif; ?>

                                    <?php if( $btn2_text != '' ): ?>
                                        <a href="<?php echo esc_url($link_two); ?>" class="optional-btn"><?php echo esc_html( $btn2_text ); ?></a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Rola_BannerThree_Slider );