<?php namespace Elementor;

class RolaEyeCareTreatment extends Widget_Base{
    public function get_name(){
        return "rola_eyecare_treatment";
    }
    public function get_title(){
        return "Eye care Treatment";
    }
    public function get_icon(){
        return "eicon-plus-square";
    }
    public function get_categories(){
        return ['rolacategory'];
    }

    protected function register_controls(){

        $this-> start_controls_section(
            'tfeature_content',
            [
                'label' => __('Eye care Treatment', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image',
            [
                'label'  => __( 'Image', 'rola-toolkit' ),
                'type'	 => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'icon',
            [
                'label'      => __( ' Icon', 'rola-toolkit' ),
                'type' 	     => Controls_Manager::SELECT,
                'options'    => rola_icons(),
            ]
        );
        $this->add_control(
            'top_title', [
                'label'       => __( 'Top Title', 'rola-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'What Clients Say', 'rola-toolkit' ),
            ]
        );
        $this->add_control(
            'title', [
                'label'       => __( 'Title', 'rola-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => __( 'What Clients Say', 'rola-toolkit' ),
            ]
        );
        $this->add_control(
            'heading_tag', [
                'label'   => __( 'Title Heading Tag', 'rola-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'sec_desc',
            [
                'label' => __('Description', 'rola-toolkit'),
                'type'  => Controls_Manager:: TEXTAREA,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'info_number',
            [
                'label' => esc_html__( 'Number', 'rola-toolkit' ),
                'type'  => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'info_content',
            [
                'label' => esc_html__( 'Content', 'rola-toolkit' ),
                'type'  => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'ecfeature_list',
            [
                'label'  => esc_html__( 'Add Feature', 'rola-toolkit' ),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // Start Content Style
        $this-> start_controls_section(
            'contact_style',
            [
                'label' => esc_html__('Content', 'rola-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_icolor',
                [
                    'label'     => __( 'Top Title Icon Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content span i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-treatment-content span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content h3, .eye-care-treatment-content h1, .eye-care-treatment-content h2, .eye-care-treatment-content h4, .eye-care-treatment-content h5, .eye-care-treatment-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-treatment-content h3, .eye-care-treatment-content h1, .eye-care-treatment-content h2, .eye-care-treatment-content h4, .eye-care-treatment-content h5, .eye-care-treatment-content h6',
                ]
            );

            $this->add_control(
                'desc_color',
                [
                    'label'     => __( 'Description Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => __( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-treatment-content p',
                ]
            );

            $this->add_control(
                'card_color',
                [
                    'label'     => __( 'Card Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content .treatment-inner-content' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_num_color',
                [
                    'label'     => __( 'Card Number Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content .treatment-inner-content .number' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_num_bgcolor',
                [
                    'label'     => __( 'Card Number Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content .treatment-inner-content .number' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_title_color',
                [
                    'label'     => __( 'Card Content Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .eye-care-treatment-content .treatment-inner-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'cc_typography',
                    'label'    => __( 'Card Content Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .eye-care-treatment-content .treatment-inner-content p',
                ]
            );
        $this-> end_controls_section();
        
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        ?>

        <div class="eye-care-treatment-area ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <?php if($settings['image']['url'] !='') : ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="eye-care-treatment-image">
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'rola-toolkit'); ?>">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                        <div class="col-lg-12 col-md-12">
                    <?php endif; ?>
                        <div class="eye-care-treatment-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title">
                                    <?php if( $settings['icon'] != '' ) : ?>
                                        <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
                                    <?php endif; ?>
                                    <?php echo esc_html( $settings['top_title'] ); ?>
                                </span>
                            <?php endif; ?>
                            <<?php echo esc_attr( $settings['heading_tag'] ); ?>><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                            <p><?php echo wp_kses_post( $settings['sec_desc'] ); ?></p>

                            <div class="row">
                                <?php foreach( $settings['ecfeature_list'] as $item ) : ?>
                                <div class="col-lg-6 col-sm-6">
                                    <div class="treatment-inner-content">
                                        <div class="number"><?php echo esc_html($item['info_number']); ?></div>
                                        <p><?php echo esc_html($item['info_content']); ?></p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php    
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new RolaEyeCareTreatment );