<?php
/**
 *  Newsletter Widget
 */

namespace Elementor;
class Rola_EC_Newsletter extends Widget_Base {

	public function get_name() {
        return 'Rola_EC_Newsletter';
    }

	public function get_title() {
        return __( 'Newsletter', 'rola-toolkit' );
    }

	public function get_icon() {
        return 'eicon-handle';
    }

	public function get_categories() {
        return [ 'rolacategory' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'rola_Section',
			[
				'label' => __( 'Section', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => __( 'What Clients Say', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'sec_desc', [
                    'label'       => __( 'Description', 'rola-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.', 'rola-toolkit' ),
                ]
            );
            $this->add_control(
                'action_url', [
                    'label'          => esc_html__( 'Action URL', 'rola-toolkit' ),
                    'description'    => __( 'Enter here your MailChimp action URL. <a href="https://docs.hibootstrap.com/docs/rola-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'rola-toolkit' ),
                    'type'           => Controls_Manager::TEXT,
                    'label_block'    => true,
                ]
            );
            $this->add_control(
                'placeholder_text', [
                    'label'   => __( 'Placeholder Text', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'Enter Your Email Address' , 'rola-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'button_icon', [
                    'label'   => __( 'Button Icon', 'rola-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => 'bx bx-send',
                    'label_block' => true,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'rola-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'sec_bg_color',
                [
                    'label'     => __( 'Section Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsletter-inner-box' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsletter-inner-box .newsletter-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .newsletter-inner-box .newsletter-content h3',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label'     => __( 'Description Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsletter-inner-box .newsletter-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'label'    => __( 'Description Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .newsletter-inner-box .newsletter-content p',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsletter-inner-box .newsletter-form button' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bg_color',
                [
                    'label'     => __( 'Button Background Color', 'rola-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .newsletter-inner-box .newsletter-form button' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'rola-toolkit' ),
                    'selector' => '{{WRAPPER}} .newsletter-inner-box .newsletter-form button',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        ?>

        <div class="newsletter-area">
            <div class="container">
                <div class="newsletter-inner-box">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="newsletter-content">
                                <h3><?php echo esc_html( $settings['title'] ); ?></h3>
							    <p><?php echo esc_html( $settings['sec_desc'] ); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <form class="mailchimp newsletter-form" method="post">
                                <input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" autocomplete="off" required>
                                <button type="submit"><i class='<?php echo esc_attr( $settings['button_icon'] ); ?>'></i></button>
                                <p class="mchimp-errmessage alert alert-danger mt-1" style="display: none;"></p>
                                <p class="mchimp-sucmessage alert alert-primary mt-1" style="display: none;"></p>
                            </form>

                            <script>
                                ;(function($){
                                    "use strict";
                                    $(document).ready(function () {
                                        // MAILCHIMP
                                        if ($(".mailchimp").length > 0) {
                                            $(".mailchimp").ajaxChimp({
                                                callback: mailchimpCallback,
                                                url: "<?php echo esc_js($settings['action_url']) ?>"
                                            });
                                        }
                                        $(".memail").on("focus", function () {
                                            $(".mchimp-errmessage").fadeOut();
                                            $(".mchimp-sucmessage").fadeOut();
                                        });
                                        $(".memail").on("keydown", function () {
                                            $(".mchimp-errmessage").fadeOut();
                                            $(".mchimp-sucmessage").fadeOut();
                                        });
                                        $(".memail").on("click", function () {
                                            $(".memail").val("");
                                        });

                                        function mailchimpCallback(resp) {
                                            if (resp.result === "success") {
                                                $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                                                $(".mchimp-sucmessage").fadeOut(500);
                                            } else if (resp.result === "error") {
                                                $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                                            }
                                        }
                                    });
                                })(jQuery)
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Rola_EC_Newsletter );