<?php
/**
 * The template for displaying search results pages
 * @package rola
 */
get_header();

// Blog Sidebar
if( isset( $rola_opt['rola_blog_sidebar'] ) ) {
    if( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar_center' ) :
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar' ) :
        $rola_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $rola_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide      = $rola_opt['rola_blog_sidebar'];
    $hide_blog_banner  = $rola_opt['hide_blog_banner'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $rola_sidebar_class = 'col-lg-8 col-md-12';
        $sidebar_hide = 'rola_with_sidebar_right';
    else:
        $rola_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide        = 'rola_without_sidebar';
    endif;
    $hide_blog_banner = false;
}
// After Hiding Banner add spacing
if( $hide_blog_banner == true ) {
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
} ?>

<!-- Start Page Title Area -->
<?php if( $hide_blog_banner == false ) : ?>
    <div class="page-banner-area">
        <div class="container">
            <div class="page-banner-content text-center">
                <h2><?php printf( esc_html__( 'Search Results for: %s', 'rola' ), '<span>' . get_search_query() . '</span>' ); ?></h2>
            </div>
        </div>
    </div>
<?php endif; ?>
<!-- End Page Title Area -->

<!-- Start Blog Area -->
<div class="blog-area pt-100 pb-100 <?php echo esc_attr( $page_spac ); ?>">
    <div class="container">
        <div class="row">
            <?php if( $sidebar_hide == 'rola_with_sidebar_left' ): ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>
            <!-- Start Blog Content -->
            <div class="<?php echo esc_attr( $rola_sidebar_class ); ?>">
                <?php
                if ( have_posts() ) :
                    while ( have_posts() ) :
                        the_post();
                        get_template_part( 'template-parts/content', get_post_format());
                    endwhile;
                else :
                    get_template_part( 'template-parts/content', 'none' );
                endif;
                ?>
        
                <!-- Stat Pagination -->
                <?php rola_pagination(); ?>
                <!-- End Pagination -->
            </div>
            <!-- End Blog Content -->
            
            <?php if( $sidebar_hide == 'rola_with_sidebar_right' ) : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>
        </div>   
    </div>
</div>
<!-- End Blog Area -->
<?php
get_footer();