<?php global $rola_opt;
/**
 * @package Rola
 */

if( isset( $rola_opt['rola_blog_sidebar'] ) ) {
    if( $rola_opt['rola_blog_sidebar'] == 'rola_without_sidebar' ) :
        $thumb_size = 'full';
    else:
        $thumb_size = 'rola_standard_card';
    endif;
} else {
    $thumb_size = 'rola_standard_card';
}

$is_post_meta   = isset( $rola_opt['is_post_meta']) ? $rola_opt['is_post_meta'] : false;
$is_post_date   = isset( $rola_opt['is_post_date']) ? $rola_opt['is_post_date'] : true;
$hide_read_more = isset( $rola_opt['hide_read_more']) ? $rola_opt['hide_read_more'] : false;
$hide_excerpt   = isset( $rola_opt['hide_excerpt']) ? $rola_opt['hide_excerpt'] : false;
$categories = get_the_category();
?>

<div <?php post_class(); ?>>
    <div class="single-blog-post">
        <?php if( has_post_thumbnail() ) { ?>
            <div class="entry-thumbnail">
                <a href="<?php the_permalink() ?>" class="d-block">
                    <img src="<?php the_post_thumbnail_url( $thumb_size ) ?>" alt="<?php the_title_attribute(); ?>">
                </a>
                
                <?php if( $is_post_date  == false ) : ?>
                    <div class="tag"><?php echo esc_html(get_the_date()) ?></div>
                <?php endif; ?>
            </div>
        <?php } ?>

        <div class="post-content">
            <?php if( get_the_title() != '' ) : ?>
                <h3 class="title"><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
            <?php endif; ?>

            <?php if( $hide_excerpt == false ): ?>
                <?php the_excerpt(); ?>
            <?php endif; ?>

            <?php if( $hide_read_more == false ): ?>
                <?php if( isset( $rola_opt['post_read_more'] ) && $rola_opt['post_read_more'] != '') : ?>
                    <a href="<?php the_permalink() ?>" class="default-btn">
                        <?php echo esc_html( $rola_opt['post_read_more'] ); ?>
                    </a>
                <?php else: ?>
                    <a href="<?php the_permalink() ?>" class="default-btn">
                        <?php esc_html_e('Read more', 'rola'); ?>
                    </a>
                <?php endif; ?>
            <?php endif; ?>

            <?php if( $is_post_meta  == false ) { ?>
                <ul class="entry-meta">
                    <li>  
                        <i class='bx bxs-user'></i>
                        <span> <?php esc_html_e('By ', 'rola'); ?><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                            <?php the_author() ?>
                        </a></span>
                    </li>
                    <li>
                        <i class='bx bxs-comment'></i>
                        <?php comments_number(); ?>
                    </li>
                </ul>
            <?php } ?>

        </div>
    </div>

</div>
 