<?php global $rola_opt;

/**
 * @package Rola
 */


$search_placeholder  = !empty($rola_opt['service_search_placeholder']) ? $rola_opt['service_search_placeholder'] : '';
$count              = !empty($rola_opt['services_post_count']) ? $rola_opt['services_post_count'] : 6;
$service_title      = !empty($rola_opt['service_title']) ? $rola_opt['service_title'] : '';
$work_title         = !empty(get_field('working_title')) ? get_field('working_title') : '';

$quote_info         = !empty(get_field('quote_info')) ? get_field('quote_info') : '';
$quote_rating       = !empty(get_field('quote_rating')) ? get_field('quote_rating') : '5';
$quote_name         = !empty(get_field('quote_name')) ? get_field('quote_name') : '';
$quote_des          = !empty(get_field('quote_des')) ? get_field('quote_des') : '';
$quote_image        = !empty(get_field('quote_image')) ? get_field('quote_image') : '';

?>


<div class="col-lg-4 col-md-12">
    <div class="widget-area">
        <div class="widget widget_search">
            <form class="search-form" role="search" method="get" action="<?php echo home_url( '/' ); ?>">
                <input type="hidden" name="post_type" value="service" />
                <input type="text" class="search-field" placeholder="<?php echo esc_attr($search_placeholder); ?>" name="s">
                <button><i class='bx bx-search-alt'></i></button>
            </form>
        </div>

        <div class="widget widget_popular_service">
            <?php if( $service_title != '') : ?>
                <h3 class="widget-title"><?php echo esc_html( $service_title ); ?></h3>
            <?php endif; ?>
            
            <ul class="popular-service-list">
                <?php 
                global $loop;
                //$services_posts  = array( 'post_type' => 'service', 'posts_per_page' => $count,  'order' => 'ASC' );
                $services_posts  = array( 'post_type' => 'service', 'posts_per_page' => $count );
                $services_query  = new WP_Query( $services_posts );
                if($services_query->have_posts()){
                    while($services_query->have_posts()){ $services_query->the_post(); 
                    ?>
                    <li class="<?php rola_if_current('active'); ?>">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            <a href="<?php the_permalink(); ?>"><i class='bx bx-chevrons-right'></i></a>
                        </div>
                    </li>
                    <?php
                    }
                }
                wp_reset_postdata();
                ?>
            </ul>
        </div>
        
        <?php if( have_rows('working_time_info') || $work_title != '' ) : ?>
            <div class="widget widget_working_time">
                <?php if( $work_title != '') : ?>
                    <h3 class="widget-title"><?php echo esc_html( $work_title ); ?></h3>
                <?php endif; ?>

                <?php if( have_rows('working_time_info') ) : ?>
                    <ul class="working-time-list">
                        <?php while( have_rows('working_time_info') ): the_row(); ?>
                            <li>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span><?php echo esc_html( get_sub_field('time_label') ); ?></span>
                                    <span><?php echo esc_html( get_sub_field('work_time') ); ?></span>
                                </div>
                            </li>
                        <?php endwhile; ?>
                    </ul>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if( $quote_info != '' || $quote_rating != ''  || $quote_name != '' || $quote_des != '' ) : ?>
            <div class="widget widget_quote_info">
                <div class="quote-info-box">
                    <div class="info-item">
                        <div class="rating">
                            <?php for( $i = 1; $i <= $quote_rating; $i++ ) { ?>
                                <i class="flaticon-star"></i>
                            <?php } ?>
                        </div>
                        <?php if( $quote_info != '' ) : ?>
                            <p><?php  echo esc_html( $quote_info ); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="info">
                        <?php if( $quote_image != '') : ?>
                            <img src="<?php echo esc_url( $quote_image ); ?>" alt="<?php esc_attr_e( 'Image', 'rola' ); ?>">
                        <?php endif; ?>

                        <h3><?php  echo esc_html( $quote_name ); ?></h3>
                        <span><?php  echo esc_html( $quote_des ); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </div>

</div>