<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
global $rola_opt;

$product_quick_view  = isset( $rola_opt['rola_product_quick_view']) ? $rola_opt['rola_product_quick_view'] : 'enabled';

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
} ?>
<div class="col-lg-4 col-sm-6 col-md-6">
    <div class="single-products-box">

        <a href="<?php the_permalink(); ?>" class="d-block">
            <?php the_post_thumbnail( 'rola_product_card' ); ?>
        </a>

        <?php if ( ! $product->is_in_stock() ) { ?>
            <span class="out-of-stock"><?php esc_html_e( 'Out of Stock', 'rola' ); ?></span>
        <?php } ?>

        <?php if( function_exists('acf_add_options_page') && get_field( 'product_type_title' ) != '' ) { ?>
            <span class="hot"><?php echo esc_html(  get_field( 'product_type_title' ) ); ?></span>
        <?php } ?>

        <ul class="products-button">
            <?php if( $product_quick_view == 'enabled' ) { ?>
                <li>
                    <div class="quick-view-btn">
                        <a href="#" data-bs-toggle="modal" class="productsquickview" data-bs-target="#productsQuickView<?php echo esc_attr(get_the_ID()); ?>">
                        </a>
                    </div>
                </li>
            <?php } ?>

            <li><a href="<?php the_permalink(); ?>" target="_blank"><i class='bx bx-link'></i></a></li>
            
            <?php if ( class_exists( 'YITH_WCWL' ) ) { ?>
            
                <li>
                    <div class="wishlist-btn">
                        <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist]')); ?>
                    </div>
                </li>
                
            <?php } ?>
        </ul>
        
        <?php if($product->is_on_sale()): ?>
            <span class="sale"><?php esc_html_e( 'SALE', 'rola' ); ?></span>
        <?php endif; ?>

        <div class="content">
            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

            <!-- Add to Cart -->
            <?php woocommerce_template_loop_add_to_cart(); ?>

            <?php woocommerce_template_loop_price(); ?>

        </div>
        
    </div>
</div>

